/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.github.Repo;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public final class RepositoryStatistics {
    private final transient Repo repo;

    public RepositoryStatistics(Repo repository) {
        this.repo = repository;
    }

    public Map<String, Object> toMap() throws IOException {
        JsonObject json = this.repo.json();
        return Arrays.stream(Key.values()).collect(Collectors.toMap(key -> ((Key)key).key, key -> key.value(json)));
    }

    private static enum Key {
        LANGUAGE("language"),
        FORKS_COUNT("forks_count"),
        STARGAZERS_COUNT("stargazers_count"),
        WATCHERS_COUNT("watchers_count"),
        SIZE("size"),
        OPEN_ISSUES_COUNT("open_issues_count"),
        CREATED_AT("created_at"),
        UPDATED_AT("updated_at");

        private final String key;

        private Key(String json) {
            this.key = json;
        }

        public String getKey() {
            return this.key;
        }

        Object value(JsonObject object) {
            if (!object.containsKey((Object)this.key)) {
                throw new IllegalStateException(String.format("JSON object '%s' doesn't contain attribute '%s'", object, this.key));
            }
            JsonValue value = (JsonValue)object.get((Object)this.key);
            JsonValue.ValueType type = value.getValueType();
            Object result = type == JsonValue.ValueType.NUMBER ? Integer.valueOf(((JsonNumber)value).intValue()) : ((JsonString)value).getString();
            return result;
        }
    }

    public static final class Smart {
        private final transient RepositoryStatistics stats;

        public Smart(Repo repo) {
            this(new RepositoryStatistics(repo));
        }

        public Smart(RepositoryStatistics statistics) {
            this.stats = statistics;
        }

        public int forks() throws IOException {
            return this.integer(Key.FORKS_COUNT);
        }

        public int stargazers() throws IOException {
            return this.integer(Key.STARGAZERS_COUNT);
        }

        public int watchers() throws IOException {
            return this.integer(Key.WATCHERS_COUNT);
        }

        public int size() throws IOException {
            return this.integer(Key.SIZE);
        }

        public int openIssues() throws IOException {
            return this.integer(Key.OPEN_ISSUES_COUNT);
        }

        public ZonedDateTime created() throws IOException {
            return this.datetime(Key.CREATED_AT);
        }

        private int integer(Key key) throws IOException {
            return Integer.parseInt(String.valueOf(this.stats.toMap().get(key.getKey())));
        }

        private ZonedDateTime datetime(Key key) throws IOException {
            return ZonedDateTime.parse(String.valueOf(this.stats.toMap().get(key.getKey())));
        }
    }
}

