/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;

@Immutable
public interface Commit
extends Comparable<Commit>,
JsonReadable {
    public Repo repo();

    public String sha();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Commit {
        private final transient Commit commit;
        private final transient SmartJson jsn;

        public Smart(Commit cmt) {
            this.commit = cmt;
            this.jsn = new SmartJson(cmt);
        }

        public String message() throws IOException {
            return this.jsn.json().getJsonObject("commit").getString("message");
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public Repo repo() {
            return this.commit.repo();
        }

        @Override
        public String sha() {
            return this.commit.sha();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.commit.json();
        }

        @Override
        public int compareTo(Commit obj) {
            return this.commit.compareTo(obj);
        }

        @Generated
        public String toString() {
            return "Commit.Smart(commit=" + this.commit + ", jsn=" + this.jsn + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Commit this$commit = this.commit;
            Commit other$commit = other.commit;
            if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Commit $commit = this.commit;
            result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

