/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Issue;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Reaction;
import com.jcabi.github.SmartJson;
import com.jcabi.github.User;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import lombok.Generated;

@Immutable
public interface Comment
extends Comparable<Comment>,
JsonReadable,
JsonPatchable {
    public Issue issue();

    public long number();

    public void remove() throws IOException;

    public void react(Reaction var1) throws IOException;

    public Iterable<Reaction> reactions();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Comment {
        private final transient Comment comment;
        private final transient SmartJson jsn;

        public Smart(Comment cmt) {
            this.comment = cmt;
            this.jsn = new SmartJson(cmt);
        }

        public User author() throws IOException {
            return this.comment.issue().repo().github().users().get(this.comment.json().getJsonObject("user").getString("login"));
        }

        public String body() throws IOException {
            return this.jsn.text("body");
        }

        public void body(String text) throws IOException {
            this.comment.patch(Json.createObjectBuilder().add("body", text).build());
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public Date createdAt() throws IOException {
            try {
                return new GitHub.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }

        public Date updatedAt() throws IOException {
            try {
                return new GitHub.Time(this.jsn.text("updated_at")).date();
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public Issue issue() {
            return this.comment.issue();
        }

        @Override
        public long number() {
            return this.comment.number();
        }

        @Override
        public void remove() throws IOException {
            this.comment.remove();
        }

        @Override
        public void react(Reaction reaction) {
            throw new UnsupportedOperationException("react() not implemented");
        }

        public Collection<Reaction> reactions() {
            throw new UnsupportedOperationException("reactions() not implemented");
        }

        @Override
        public JsonObject json() throws IOException {
            return this.comment.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.comment.patch(json);
        }

        @Override
        public int compareTo(Comment obj) {
            return this.comment.compareTo(obj);
        }

        @Generated
        public String toString() {
            return "Comment.Smart(comment=" + this.comment + ", jsn=" + this.jsn + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Comment this$comment = this.comment;
            Comment other$comment = other.comment;
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Comment $comment = this.comment;
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

