/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.mock.ImmutableReentrantLock;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.xembly.Directive;
import org.xembly.Xembler;

@Immutable
public interface MkStorage {
    public XML xml() throws IOException;

    public void apply(Iterable<Directive> var1) throws IOException;

    public void lock() throws IOException;

    public void unlock() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Synced
    implements MkStorage {
        private final transient MkStorage origin;
        private final transient ImmutableReentrantLock lock = new ImmutableReentrantLock();

        public Synced(MkStorage storage) {
            this.origin = storage;
        }

        public String toString() {
            return this.origin.toString();
        }

        @Override
        public XML xml() throws IOException {
            return this.origin.xml();
        }

        @Override
        public void apply(Iterable<Directive> dirs) throws IOException {
            this.origin.apply(dirs);
        }

        @Override
        public void lock() {
            this.lock.lock();
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synced)) {
                return false;
            }
            Synced other = (Synced)o;
            MkStorage this$origin = this.origin;
            MkStorage other$origin = other.origin;
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            ImmutableReentrantLock this$lock = this.lock;
            ImmutableReentrantLock other$lock = other.lock;
            return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MkStorage $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            ImmutableReentrantLock $lock = this.lock;
            result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class InFile
    implements MkStorage {
        private final transient String name;

        public InFile() throws IOException {
            this(File.createTempFile("jcabi-github", ".xml"));
            new File(this.name).deleteOnExit();
        }

        public InFile(File file) throws IOException {
            FileUtils.write((File)file, (CharSequence)"<github/>", (Charset)StandardCharsets.UTF_8);
            this.name = file.getAbsolutePath();
        }

        public String toString() {
            try {
                return this.xml().toString();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XML xml() throws IOException {
            String string = this.name;
            synchronized (string) {
                return new XMLDocument(FileUtils.readFileToString((File)new File(this.name), (Charset)StandardCharsets.UTF_8));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(Iterable<Directive> dirs) throws IOException {
            String string = this.name;
            synchronized (string) {
                FileUtils.write((File)new File(this.name), (CharSequence)new XMLDocument(new Xembler(dirs).applyQuietly(this.xml().node())).toString(), (Charset)StandardCharsets.UTF_8);
            }
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InFile)) {
                return false;
            }
            InFile other = (InFile)o;
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

