/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Pull;
import com.jcabi.github.PullComment;
import com.jcabi.github.Reaction;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import java.io.IOException;
import java.util.Collection;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtPullComment
implements PullComment {
    private final transient Request request;
    private final transient Pull owner;
    private final transient int num;

    RtPullComment(Request req, Pull pull, int number) {
        Coordinates coords = pull.repo().coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/pulls").path("/comments").path(Integer.toString(number)).back();
        this.owner = pull;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public Pull pull() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void react(Reaction reaction) {
        throw new UnsupportedOperationException("React not implemented");
    }

    @Override
    public Collection<Reaction> reactions() {
        throw new UnsupportedOperationException("reactions() not implemented");
    }

    @Override
    public int compareTo(PullComment comment) {
        return this.number() - comment.number();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtPullComment)) {
            return false;
        }
        RtPullComment other = (RtPullComment)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Pull this$owner = this.owner;
        Pull other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        return this.num == other.num;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Pull $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        result = result * 59 + this.num;
        return result;
    }
}

