/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GistComments;
import com.jcabi.github.Github;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import java.io.IOException;
import java.util.ArrayList;
import javax.json.JsonObject;
import javax.json.JsonValue;

@Immutable
public interface Gist
extends JsonReadable,
JsonPatchable {
    public Github github();

    public String identifier();

    public String read(String var1) throws IOException;

    public void write(String var1, String var2) throws IOException;

    public void star() throws IOException;

    public void unstar() throws IOException;

    public boolean starred() throws IOException;

    public Gist fork() throws IOException;

    public GistComments comments() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Gist {
        private final transient Gist gist;

        public Smart(Gist gst) {
            this.gist = gst;
        }

        @Override
        public String identifier() {
            return this.gist.identifier();
        }

        public Iterable<String> files() throws IOException {
            JsonObject array = this.gist.json().getJsonObject("files");
            ArrayList<String> files = new ArrayList<String>(array.size());
            for (JsonValue value : array.values()) {
                files.add(((JsonObject)JsonObject.class.cast(value)).getString("filename"));
            }
            return files;
        }

        @Override
        public Github github() {
            return this.gist.github();
        }

        @Override
        public String read(String name) throws IOException {
            return this.gist.read(name);
        }

        @Override
        public void write(String name, String content) throws IOException {
            this.gist.write(name, content);
        }

        @Override
        public void star() throws IOException {
            this.gist.star();
        }

        @Override
        public void unstar() throws IOException {
            this.gist.unstar();
        }

        @Override
        public boolean starred() throws IOException {
            return this.gist.starred();
        }

        @Override
        public Gist fork() throws IOException {
            return this.gist.fork();
        }

        @Override
        public GistComments comments() throws IOException {
            return this.gist.comments();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.gist.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.gist.patch(json);
        }

        public String toString() {
            return "Gist.Smart(gist=" + this.gist + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Gist this$gist = this.gist;
            Gist other$gist = other.gist;
            return !(this$gist == null ? other$gist != null : !this$gist.equals(other$gist));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Gist $gist = this.gist;
            result = result * 59 + ($gist == null ? 43 : $gist.hashCode());
            return result;
        }
    }
}

