/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.Gists;
import com.jcabi.github.Github;
import com.jcabi.github.mock.MkGist;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Map;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkGists
implements Gists {
    private final transient MkStorage storage;
    private final transient String self;

    MkGists(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)"/github").addIf((Object)"gists"));
    }

    @Override
    public Github github() {
        return new MkGithub(this.storage, this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gist create(Map<String, String> files, boolean visible) throws IOException {
        String number;
        this.storage.lock();
        try {
            number = Integer.toString(1 + this.storage.xml().xpath(String.format("%s/gist/id/text()", this.xpath())).size());
            Directives dirs = new Directives().xpath((Object)this.xpath()).add((Object)"gist").add((Object)"id").set((Object)number).up().add((Object)"public").set((Object)String.valueOf(visible)).up().add((Object)"files");
            for (Map.Entry<String, String> file : files.entrySet()) {
                dirs.add((Object)"file").add((Object)"filename").set((Object)file.getKey()).up().add((Object)"raw_content").set((Object)file.getValue()).up().up();
            }
            this.storage.apply((Iterable<Directive>)dirs);
        }
        finally {
            this.storage.unlock();
        }
        return this.get(number);
    }

    @Override
    public Gist get(String name) {
        return new MkGist(this.storage, this.self, name);
    }

    @Override
    public Iterable<Gist> iterate() {
        return new MkIterable<Gist>(this.storage, String.format("%s/gist", this.xpath()), new MkIterable.Mapping<Gist>(){

            @Override
            public Gist map(XML xml) {
                return MkGists.this.get((String)xml.xpath("id/text()").get(0));
            }
        });
    }

    @Override
    public void remove(String identifier) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("%s/gist[id='%s']", this.xpath(), identifier)).remove());
    }

    private String xpath() {
        return "/github/gists";
    }

    public String toString() {
        return "MkGists(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkGists)) {
            return false;
        }
        MkGists other = (MkGists)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

