/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.jsv;

import com.github.fge.jsonschema.main.JsonSchemaFactory;

public class JsonSchemaValidatorSettings {
    private JsonSchemaFactory jsonSchemaFactory;
    private boolean checkedValidation;
    private boolean parseUriAndUrlsAsJsonNode;

    private JsonSchemaValidatorSettings(JsonSchemaFactory jsonSchemaFactory, boolean checkedValidation, boolean parseUriAndUrlsAsJsonNode) {
        if (jsonSchemaFactory == null) {
            throw new IllegalArgumentException(JsonSchemaFactory.class.getSimpleName() + " cannot be null");
        }
        this.jsonSchemaFactory = jsonSchemaFactory;
        this.checkedValidation = checkedValidation;
        this.parseUriAndUrlsAsJsonNode = parseUriAndUrlsAsJsonNode;
    }

    public JsonSchemaValidatorSettings(JsonSchemaFactory jsonSchemaFactory, boolean checkedValidation) {
        this(jsonSchemaFactory, checkedValidation, false);
    }

    public JsonSchemaValidatorSettings(JsonSchemaFactory jsonSchemaFactory) {
        this(jsonSchemaFactory, true);
    }

    public JsonSchemaValidatorSettings() {
        this(JsonSchemaFactory.byDefault(), true);
    }

    public JsonSchemaFactory jsonSchemaFactory() {
        return this.jsonSchemaFactory;
    }

    public boolean shouldParseUriAndUrlsAsJsonNode() {
        return this.parseUriAndUrlsAsJsonNode;
    }

    public boolean shouldUseCheckedValidation() {
        return this.checkedValidation;
    }

    public JsonSchemaValidatorSettings checkedValidation(boolean shouldUseCheckedValidation) {
        return new JsonSchemaValidatorSettings(this.jsonSchemaFactory, shouldUseCheckedValidation, this.parseUriAndUrlsAsJsonNode);
    }

    public JsonSchemaValidatorSettings parseUriAndUrlsAsJsonNode(boolean parseUriAndUrlsAsJsonNode) {
        return new JsonSchemaValidatorSettings(this.jsonSchemaFactory, this.checkedValidation, parseUriAndUrlsAsJsonNode);
    }

    public JsonSchemaValidatorSettings jsonSchemaFactory(JsonSchemaFactory jsonSchemaFactory) {
        return new JsonSchemaValidatorSettings(jsonSchemaFactory, this.checkedValidation, this.parseUriAndUrlsAsJsonNode);
    }

    public JsonSchemaValidatorSettings and() {
        return this;
    }

    public JsonSchemaValidatorSettings with() {
        return this;
    }

    public static JsonSchemaValidatorSettings settings() {
        return new JsonSchemaValidatorSettings();
    }
}

