/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.jsv;

import com.github.fge.jsonschema.main.JsonSchemaFactory;

public class JsonSchemaValidatorSettings {
    private JsonSchemaFactory jsonSchemaFactory;
    private boolean checkedValidation;

    public JsonSchemaValidatorSettings(JsonSchemaFactory jsonSchemaFactory, boolean checkedValidation) {
        if (jsonSchemaFactory == null) {
            throw new IllegalArgumentException(JsonSchemaFactory.class.getSimpleName() + " cannot be null");
        }
        this.jsonSchemaFactory = jsonSchemaFactory;
        this.checkedValidation = checkedValidation;
    }

    public JsonSchemaValidatorSettings(JsonSchemaFactory jsonSchemaFactory) {
        this(jsonSchemaFactory, true);
    }

    public JsonSchemaValidatorSettings() {
        this(JsonSchemaFactory.byDefault(), true);
    }

    public JsonSchemaFactory jsonSchemaFactory() {
        return this.jsonSchemaFactory;
    }

    public boolean shouldUseCheckedValidation() {
        return this.checkedValidation;
    }

    public JsonSchemaValidatorSettings checkedValidation(boolean shouldUseCheckedValidation) {
        return new JsonSchemaValidatorSettings(this.jsonSchemaFactory, shouldUseCheckedValidation);
    }

    public JsonSchemaValidatorSettings jsonSchemaFactory(JsonSchemaFactory jsonSchemaFactory) {
        return new JsonSchemaValidatorSettings(jsonSchemaFactory, this.shouldUseCheckedValidation());
    }

    public JsonSchemaValidatorSettings and() {
        return this;
    }

    public JsonSchemaValidatorSettings with() {
        return this;
    }

    public static JsonSchemaValidatorSettings settings() {
        return new JsonSchemaValidatorSettings();
    }
}

