/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GsonJsonProvider
extends AbstractJsonProvider {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new GsonBuilder().create();

    @Override
    public Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JsonElement)) {
            return o;
        }
        JsonElement e = (JsonElement)o;
        if (e.isJsonNull()) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                return p.getAsString();
            }
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return GsonJsonProvider.unwrapNumber(p.getAsNumber());
            }
        }
        return o;
    }

    private static Number unwrapNumber(Number n) {
        LazilyParsedNumber lpn;
        BigDecimal bigDecimal;
        Number unwrapped = n instanceof LazilyParsedNumber ? (Number)((bigDecimal = new BigDecimal((lpn = (LazilyParsedNumber)n).toString())).scale() <= 0 ? (Number)(bigDecimal.compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0 ? (Number)bigDecimal.intValue() : (Number)bigDecimal.longValue()) : (Number)bigDecimal.doubleValue()) : (Number)n;
        return unwrapped;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        return parser.parse(json);
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return parser.parse((Reader)new InputStreamReader(jsonStream, charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        return obj.toString();
    }

    @Override
    public Object createArray() {
        return new JsonArray();
    }

    @Override
    public Object createMap() {
        return new JsonObject();
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JsonArray || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return this.toJsonArray(obj).get(idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        JsonArray a = this.toJsonArray(array);
        if (index == a.size()) {
            a.add(this.createJsonElement(newValue));
        } else {
            a.set(index, this.createJsonElement(newValue));
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        JsonObject jsonObject = this.toJsonObject(obj);
        JsonElement o = jsonObject.get(key);
        if (!jsonObject.has(key)) {
            return UNDEFINED;
        }
        return this.unwrap(o);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).add(key.toString(), this.createJsonElement(value));
        } else {
            JsonArray array;
            int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : array.size();
            if (index == (array = this.toJsonArray(obj)).size()) {
                array.add(this.createJsonElement(value));
            } else {
                array.set(index, this.createJsonElement(value));
            }
        }
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key.toString());
        } else {
            JsonArray array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            array.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof JsonObject;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry entry : this.toJsonObject(obj).entrySet()) {
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    @Override
    public int length(Object obj) {
        JsonElement element;
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).size();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).entrySet().size();
        }
        if (obj instanceof JsonElement && (element = this.toJsonElement(obj)).isJsonPrimitive()) {
            return element.toString().length();
        }
        throw new JsonPathException("length operation can not applied to " + obj != null ? obj.getClass().getName() : "null");
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        JsonArray arr = this.toJsonArray(obj);
        ArrayList<Object> values = new ArrayList<Object>(arr.size());
        for (Object o : arr) {
            values.add(this.unwrap(o));
        }
        return values;
    }

    private JsonElement createJsonElement(Object o) {
        return gson.toJsonTree(o);
    }

    private JsonArray toJsonArray(Object o) {
        return (JsonArray)o;
    }

    private JsonObject toJsonObject(Object o) {
        return (JsonObject)o;
    }

    private JsonElement toJsonElement(Object o) {
        return (JsonElement)o;
    }
}

