/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;

public abstract class PathToken {
    private PathToken next;
    private Boolean definite = null;

    PathToken appendTailToken(PathToken next) {
        this.next = next;
        return next;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleObjectProperty(String currentPath, Object model, EvaluationContextImpl ctx, List<String> properties) {
        if (properties.size() == 1) {
            String property = properties.get(0);
            String evalPath = currentPath + "['" + property + "']";
            Object propertyVal = PathToken.readObjectProperty(property, model, ctx);
            if (propertyVal == JsonProvider.UNDEFINED) {
                if (!this.isLeaf()) throw new PathNotFoundException();
                if (ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                    propertyVal = null;
                } else {
                    if (!ctx.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) throw new PathNotFoundException("No results for path: " + evalPath);
                    return;
                }
            }
            if (this.isLeaf()) {
                ctx.addResult(evalPath, propertyVal);
                return;
            } else {
                this.next().evaluate(evalPath, propertyVal, ctx);
            }
            return;
        } else {
            String evalPath = currentPath + "[" + Utils.join(", ", "'", properties) + "]";
            if (!this.isLeaf()) {
                throw new InvalidPathException("Multi properties can only be used as path leafs: " + evalPath);
            }
            for (String property : properties) {
                evalPath = currentPath + "['" + property + "']";
                if (PathToken.hasProperty(property, model, ctx)) {
                    Object propertyVal = PathToken.readObjectProperty(property, model, ctx);
                    if (propertyVal == JsonProvider.UNDEFINED) {
                        if (!ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) continue;
                        propertyVal = null;
                    }
                    ctx.addResult(evalPath, propertyVal);
                    continue;
                }
                if (!ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) continue;
                ctx.addResult(evalPath, null);
            }
        }
    }

    private static boolean hasProperty(String property, Object model, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getPropertyKeys(model).contains(property);
    }

    private static Object readObjectProperty(String property, Object model, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getMapValue(model, property);
    }

    void handleArrayIndex(int index, String currentPath, Object json, EvaluationContextImpl ctx) {
        String evalPath = currentPath + "[" + index + "]";
        try {
            Object evalHit = ctx.jsonProvider().getArrayIndex(json, index);
            if (this.isLeaf()) {
                ctx.addResult(evalPath, evalHit);
            } else {
                this.next().evaluate(evalPath, evalHit, ctx);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PathNotFoundException("Index out of bounds when evaluating path " + evalPath);
        }
    }

    PathToken next() {
        if (this.isLeaf()) {
            throw new IllegalStateException("Current path token is a leaf");
        }
        return this.next;
    }

    boolean isLeaf() {
        return this.next == null;
    }

    public int getTokenCount() {
        int cnt = 1;
        PathToken token = this;
        while (!token.isLeaf()) {
            token = token.next();
            ++cnt;
        }
        return cnt;
    }

    public boolean isPathDefinite() {
        if (this.definite != null) {
            return this.definite;
        }
        boolean isDefinite = this.isTokenDefinite();
        if (isDefinite && !this.isLeaf()) {
            isDefinite = this.next.isPathDefinite();
        }
        this.definite = isDefinite;
        return isDefinite;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.getPathFragment();
        }
        return this.getPathFragment() + this.next().toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public abstract void evaluate(String var1, Object var2, EvaluationContextImpl var3);

    abstract boolean isTokenDefinite();

    abstract String getPathFragment();
}

