/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.spi.json;

import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonProvider
implements JsonProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJsonProvider.class);

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return ((List)obj).get(idx);
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        Map m = (Map)obj;
        if (!m.containsKey(key)) {
            return JsonProvider.UNDEFINED;
        }
        return m.get(key);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            ((Map)obj).put(key.toString(), value);
        } else {
            List list = (List)obj;
            int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : list.size();
            list.add(index, value);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        if (this.isArray(obj)) {
            throw new UnsupportedOperationException();
        }
        return ((Map)obj).keySet();
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return ((List)obj).size();
        }
        if (this.isMap(obj)) {
            return this.getPropertyKeys(obj).size();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        throw new JsonPathException("length operation can not applied to " + obj != null ? obj.getClass().getName() : "null");
    }

    public Iterable<? extends Object> toIterable(Object obj) {
        if (this.isArray(obj)) {
            return (Iterable)obj;
        }
        return ((Map)obj).values();
    }
}

