/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Filter
implements Predicate {
    protected final List<Predicate> criteriaList;

    private Filter() {
        this.criteriaList = Collections.emptyList();
    }

    private Filter(Predicate criteria) {
        this.criteriaList = Collections.singletonList(criteria);
    }

    private Filter(List<Predicate> criteriaList) {
        this.criteriaList = new ArrayList<Predicate>(criteriaList);
    }

    public static Filter filter(Predicate criteria) {
        return new Filter(criteria);
    }

    public static Filter filter(List<Predicate> criteriaList) {
        return new Filter(criteriaList);
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        for (Predicate criteria : this.criteriaList) {
            if (criteria.apply(ctx)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Predicate crit : this.criteriaList) {
            sb.append(crit.toString());
        }
        return sb.toString();
    }

    public Filter or(Predicate other) {
        return new OrFilter(this, other);
    }

    public Filter and(Predicate other) {
        return Filter.filter(Arrays.asList(this, other));
    }

    private static final class OrFilter
    extends Filter {
        private final Predicate left;
        private final Predicate right;

        private OrFilter(Predicate left, Predicate right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            boolean a = this.left.apply(ctx);
            return a || this.right.apply(ctx);
        }
    }
}

