/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.internal.spi.mapper.DefaultMappingProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class Configuration {
    private static Defaults DEFAULTS = new Defaults(){
        private final MappingProvider mappingProvider = new DefaultMappingProvider();

        @Override
        public JsonProvider jsonProvider() {
            return new JsonSmartJsonProvider();
        }

        @Override
        public Set<Option> options() {
            return EnumSet.noneOf(Option.class);
        }

        @Override
        public MappingProvider mappingProvider() {
            return this.mappingProvider;
        }
    };
    private final JsonProvider jsonProvider;
    private final MappingProvider mappingProvider;
    private final Set<Option> options;

    public static synchronized void setDefaults(Defaults defaults) {
        DEFAULTS = defaults;
    }

    private Configuration(JsonProvider jsonProvider, MappingProvider mappingProvider, EnumSet<Option> options) {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(mappingProvider, "mappingProvider can not be null", new Object[0]);
        Utils.notNull(options, "setOptions can not be null", new Object[0]);
        this.jsonProvider = jsonProvider;
        this.mappingProvider = mappingProvider;
        this.options = Collections.unmodifiableSet(options);
    }

    public Configuration jsonProvider(JsonProvider newJsonProvider) {
        return Configuration.builder().jsonProvider(newJsonProvider).mappingProvider(this.mappingProvider).options(this.options).build();
    }

    public JsonProvider jsonProvider() {
        return this.jsonProvider;
    }

    public Configuration mappingProvider(MappingProvider newMappingProvider) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(newMappingProvider).options(this.options).build();
    }

    public MappingProvider mappingProvider() {
        return this.mappingProvider;
    }

    public Configuration addOptions(Option ... options) {
        EnumSet<Option> opts = EnumSet.noneOf(Option.class);
        opts.addAll(this.options);
        opts.addAll(Arrays.asList(options));
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(opts).build();
    }

    public Configuration setOptions(Option ... options) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(options).build();
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean containsOption(Option option) {
        return this.options.contains((Object)option);
    }

    public static Configuration defaultConfiguration() {
        return Configuration.builder().jsonProvider(DEFAULTS.jsonProvider()).options(DEFAULTS.options()).build();
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static interface Defaults {
        public JsonProvider jsonProvider();

        public Set<Option> options();

        public MappingProvider mappingProvider();
    }

    public static class ConfigurationBuilder {
        private JsonProvider jsonProvider;
        private MappingProvider mappingProvider;
        private EnumSet<Option> options = EnumSet.noneOf(Option.class);

        public ConfigurationBuilder jsonProvider(JsonProvider provider) {
            this.jsonProvider = provider;
            return this;
        }

        public ConfigurationBuilder mappingProvider(MappingProvider provider) {
            this.mappingProvider = provider;
            return this;
        }

        public ConfigurationBuilder options(Option ... flags) {
            if (flags.length > 0) {
                this.options.addAll(Arrays.asList(flags));
            }
            return this;
        }

        public ConfigurationBuilder options(Set<Option> options) {
            this.options.addAll(options);
            return this;
        }

        public Configuration build() {
            if (this.jsonProvider == null) {
                this.jsonProvider = DEFAULTS.jsonProvider();
            }
            if (this.mappingProvider == null) {
                this.mappingProvider = DEFAULTS.mappingProvider();
            }
            return new Configuration(this.jsonProvider, this.mappingProvider, this.options);
        }
    }
}

