/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonModel {
    private Object jsonObject;
    private JsonProvider jsonProvider = JsonProvider.getInstance();

    public JsonModel(String json) {
        this.jsonObject = this.jsonProvider.parse(json);
    }

    private JsonModel(Object jsonObject) {
        this.jsonObject = jsonObject;
    }

    public static JsonModel create(String json) {
        return new JsonModel(json);
    }

    public <T> T get(String jsonPath) {
        JsonPath path = JsonPath.compile(this.jsonProvider, jsonPath);
        return this.get(path);
    }

    public <T> T get(JsonPath jsonPath) {
        return jsonPath.read(this.jsonObject);
    }

    public String getJson(JsonPath jsonPath) {
        return this.jsonProvider.toJson(jsonPath.read(this.jsonObject));
    }

    public JsonModel getModel(String jsonPath) {
        JsonPath path = JsonPath.compile(this.jsonProvider, jsonPath);
        return this.getModel(path);
    }

    public JsonModel getModel(JsonPath jsonPath) {
        Object subModel = jsonPath.read(this.jsonObject);
        return new JsonModel(subModel);
    }

    public JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public String getJson() {
        return this.jsonProvider.toJson(this.jsonObject);
    }
}

