/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    protected static Class[] getElementsByNSParameterTypes = new Class[]{String.class, String.class};

    public static String findDavPrefix(Document document) {
        Element multistatus = document.getDocumentElement();
        NamedNodeMap list = multistatus.getAttributes();
        String prefix = "DAV:";
        for (int i2 = 0; i2 < list.getLength(); ++i2) {
            try {
                Attr attr = (Attr)list.item(i2);
                if (attr.getName() == null || !attr.getName().startsWith("xmlns") || !attr.getValue().equals("DAV:")) continue;
                int indx = attr.getName().indexOf(":");
                if (indx >= 0 && indx < attr.getName().length() - 1) {
                    prefix = attr.getName().substring(indx + 1) + ":";
                    continue;
                }
                prefix = "";
                continue;
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
        }
        return prefix;
    }

    public static String getTextValue(Node node) {
        StringBuffer text = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (nodeList.item(i2).getNodeType() == 3 || nodeList.item(i2).getNodeType() == 4) {
                text.append(((Text)nodeList.item(i2)).getData());
                continue;
            }
            text.append(DOMUtils.getTextValue(nodeList.item(i2)));
        }
        return text.toString();
    }

    public static int parseStatus(String statusString) {
        int status = -1;
        if (statusString != null) {
            StringTokenizer tokenizer = new StringTokenizer(statusString);
            if (tokenizer.countTokens() >= 2) {
                tokenizer.nextElement();
                String statusCode = tokenizer.nextElement().toString();
                try {
                    status = Integer.parseInt(statusCode);
                }
                catch (NumberFormatException e2) {
                    throw new IllegalArgumentException("Status code is not numeric");
                }
            } else {
                throw new IllegalArgumentException("There aren't enough words in the input argument");
            }
        }
        return status;
    }

    public static String getElementNamespaceURI(Element element) {
        String namespace = null;
        if (element == null) {
            throw new IllegalArgumentException("The element cannot be null");
        }
        try {
            namespace = element.getNamespaceURI();
        }
        catch (NoSuchMethodError e2) {
            String tagName = element.getTagName();
            String attribute = "xmlns";
            int index = tagName.indexOf(":");
            if (index > 0 && index < tagName.length() - 1) {
                attribute = attribute + ":" + tagName.substring(0, index);
            }
            boolean found = false;
            for (Node node = element; !found && node != null; node = node.getParentNode()) {
                try {
                    String tmp = node.getAttribute(attribute);
                    if (tmp == null || tmp.equals("")) continue;
                    namespace = tmp;
                    found = true;
                    continue;
                }
                catch (ClassCastException f2) {
                    // empty catch block
                }
            }
        }
        return namespace;
    }

    public static String getElementLocalName(Element element) {
        String localName;
        block3: {
            localName = null;
            if (element == null) {
                throw new IllegalArgumentException("The element cannot be null");
            }
            try {
                localName = element.getLocalName();
            }
            catch (NoSuchMethodError e2) {
                localName = element.getTagName();
                int index = localName.indexOf(":");
                if (index <= 0 || index >= localName.length() - 1) break block3;
                localName = localName.substring(index + 1);
            }
        }
        return localName;
    }

    public static NodeList getElementsByTagNameNS(Node node, String tagName, String namespace) {
        NodeList list = null;
        if (node == null) {
            return null;
        }
        if (!(node instanceof Document) && !(node instanceof Element)) {
            throw new IllegalArgumentException("The node parameter must be an Element or a Document node");
        }
        try {
            list = ((Element)node).getElementsByTagNameNS(namespace, tagName);
        }
        catch (NoSuchMethodError e2) {
            Vector vector = new Vector();
            DOMUtils.getChildElementsByTagNameNS(vector, node, tagName, namespace);
            list = new NodeListImpl(vector);
        }
        return list;
    }

    protected static void getChildElementsByTagNameNS(Vector vector, Node node, String tagName, String namespace) {
        NodeList list = node.getChildNodes();
        for (int i2 = 0; list != null && i2 < list.getLength(); ++i2) {
            try {
                Element element = (Element)list.item(i2);
                if (tagName.equals(DOMUtils.getElementLocalName(element)) && namespace.equals(DOMUtils.getElementNamespaceURI(element))) {
                    vector.addElement(element);
                    continue;
                }
                DOMUtils.getChildElementsByTagNameNS(vector, element, tagName, namespace);
                continue;
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
        }
    }

    public static Element getFirstElement(Node node, String namespace, String name) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return null;
        }
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            try {
                Element child = (Element)children.item(i2);
                if (!name.equals(DOMUtils.getElementLocalName(child)) || !namespace.equals(DOMUtils.getElementNamespaceURI(child))) continue;
                return child;
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
        }
        return null;
    }

    static class NodeListImpl
    implements NodeList {
        private Vector vector = null;

        NodeListImpl(Vector vector) {
            this.vector = vector;
        }

        public int getLength() {
            return this.vector.size();
        }

        public Node item(int i2) {
            return (Node)this.vector.elementAt(i2);
        }
    }
}

