/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavException;
import org.apache.webdav.lib.properties.AclProperty;
import org.apache.webdav.lib.properties.CheckedinProperty;
import org.apache.webdav.lib.properties.CheckedoutProperty;
import org.apache.webdav.lib.properties.CreationDateProperty;
import org.apache.webdav.lib.properties.CurrentUserPrivilegeSetProperty;
import org.apache.webdav.lib.properties.GetContentLengthProperty;
import org.apache.webdav.lib.properties.GetLastModifiedProperty;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import org.apache.webdav.lib.properties.ModificationDateProperty;
import org.apache.webdav.lib.properties.OwnerProperty;
import org.apache.webdav.lib.properties.PrincipalCollectionSetProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;
import org.apache.webdav.lib.properties.SupportedLockProperty;
import org.w3c.dom.Element;

public class PropertyFactory {
    private static final Class[] CTOR_PARAMS = new Class[]{ResponseEntity.class, Element.class};
    private static Map propertyClasses = new HashMap();

    public static Property create(ResponseEntity response, Element element) {
        Constructor ctor;
        Map nsMap = (Map)propertyClasses.get(element.getNamespaceURI());
        if (nsMap != null && (ctor = (Constructor)nsMap.get(element.getLocalName())) != null) {
            try {
                Object[] params = new Object[]{response, element};
                return (Property)ctor.newInstance(params);
            }
            catch (Exception e2) {
                throw new WebdavException(e2);
            }
        }
        return new BaseProperty(response, element);
    }

    public static void register(String namespaceUri, String elementName, Class cls) throws NoSuchMethodException, SecurityException {
        Constructor ctor = cls.getConstructor(CTOR_PARAMS);
        HashMap nsMap = (HashMap)propertyClasses.get(namespaceUri);
        if (nsMap == null) {
            nsMap = new HashMap();
            propertyClasses.put(namespaceUri, nsMap);
        }
        nsMap.put(elementName, ctor);
    }

    static {
        try {
            PropertyFactory.register("DAV:", "acl", AclProperty.class);
            PropertyFactory.register("DAV:", "checked-in", CheckedinProperty.class);
            PropertyFactory.register("DAV:", "checked-out", CheckedoutProperty.class);
            PropertyFactory.register("DAV:", "creationdate", CreationDateProperty.class);
            PropertyFactory.register("DAV:", "current-user-privilege-set", CurrentUserPrivilegeSetProperty.class);
            PropertyFactory.register("DAV:", "getcontentlength", GetContentLengthProperty.class);
            PropertyFactory.register("DAV:", "getlastmodified", GetLastModifiedProperty.class);
            PropertyFactory.register("DAV:", "lockdiscovery", LockDiscoveryProperty.class);
            PropertyFactory.register("DAV:", "modificationdate", ModificationDateProperty.class);
            PropertyFactory.register("DAV:", "owner", OwnerProperty.class);
            PropertyFactory.register("DAV:", "principal-collection-set", PrincipalCollectionSetProperty.class);
            PropertyFactory.register("DAV:", "resourcetype", ResourceTypeProperty.class);
            PropertyFactory.register("DAV:", "supportedlock", SupportedLockProperty.class);
        }
        catch (Exception e2) {
            throw new WebdavException(e2);
        }
    }
}

