/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.util.ArrayList;
import jec.httpclient.URIException;
import jec.httpclient.util.URIUtil;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AclProperty
extends BaseProperty {
    public static final String TAG_NAME = "acl";

    public AclProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public Ace[] getAces() {
        NodeList children = this.element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        ArrayList<Ace> aces = new ArrayList<Ace>();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            try {
                String localName;
                Element child = (Element)children.item(i2);
                String namespace = DOMUtils.getElementNamespaceURI(child);
                if (namespace == null || !namespace.equals("DAV:") || !"ace".equals(localName = DOMUtils.getElementLocalName(child))) continue;
                aces.add(this.parseAce(child));
                continue;
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
        }
        return aces.toArray(new Ace[aces.size()]);
    }

    protected Ace parseAce(Element element) {
        String principal = null;
        Element child = DOMUtils.getFirstElement(element, "DAV:", "principal");
        if (child == null) {
            System.err.println("Error: mandatory element <principal> is missing !");
            System.err.println("element: " + element);
            return null;
        }
        Element href = DOMUtils.getFirstElement(child, "DAV:", "href");
        if (href != null) {
            principal = DOMUtils.getTextValue(href);
            try {
                principal = URIUtil.decode(principal);
            }
            catch (URIException e2) {
                System.err.println("Warning: decoding href element failed!");
                System.err.println("reason: " + e2.getReason());
            }
        }
        String[] types = new String[]{"all", "authenticated", "unauthenticated", "property", "self"};
        for (int i2 = 0; i2 < types.length && principal == null; ++i2) {
            Element type = DOMUtils.getFirstElement(child, "DAV:", types[i2]);
            if (type == null) continue;
            principal = types[i2];
        }
        if (principal == null) {
            System.err.println("Error: unknown type of principal");
            System.err.println("element: " + element);
            return null;
        }
        Ace ace = new Ace(principal);
        child = DOMUtils.getFirstElement(element, "DAV:", "grant");
        if (child == null) {
            child = DOMUtils.getFirstElement(element, "DAV:", "deny");
            ace.setNegative(true);
        }
        if (child != null) {
            NodeList privilegeElements = child.getElementsByTagNameNS("DAV:", "privilege");
            for (int i3 = 0; i3 < privilegeElements.getLength(); ++i3) {
                Element privilegeElement = (Element)privilegeElements.item(i3);
                NodeList privileges = privilegeElement.getElementsByTagName("*");
                for (int j2 = 0; j2 < privileges.getLength(); ++j2) {
                    Element privilege = (Element)privileges.item(j2);
                    ace.addPrivilege(this.parsePrivilege(privilege));
                }
            }
        }
        if ((child = DOMUtils.getFirstElement(element, "DAV:", "inherited")) != null) {
            href = DOMUtils.getFirstElement(child, "DAV:", "href");
            String shref = null;
            if (href != null) {
                shref = DOMUtils.getTextValue(href);
                if (!shref.equals(this.response.getHref())) {
                    ace.setInherited(true);
                    ace.setInheritedFrom(shref);
                }
            } else {
                System.err.println("Error: mandatory element <href> is missing !");
                return null;
            }
        }
        if ((child = DOMUtils.getFirstElement(element, "DAV:", "protected")) != null) {
            ace.setProtected(true);
        }
        return ace;
    }

    protected Privilege parsePrivilege(Element privilegeElement) {
        return new Privilege(privilegeElement.getNamespaceURI(), privilegeElement.getLocalName(), null);
    }

    public String getPropertyAsString() {
        Ace[] aces = this.getAces();
        if (aces == null || aces.length == 0) {
            return "";
        }
        StringBuffer tmp = new StringBuffer(aces[0].toString());
        for (int i2 = 1; i2 < aces.length; ++i2) {
            tmp.append(", ");
            tmp.append(aces[i2].toString());
        }
        return tmp.toString();
    }
}

