/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import jec.httpclient.Header;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class SubscribeMethod
extends XMLResponseMethodBase
implements DepthSupport {
    private static final String HEADER_SUBSCRIPTION_ID = "Subscription-Id";
    private static final String HEADER_SUBSCRIPTION_LIFETIME = "Subscription-Lifetime";
    private static final String HEADER_NOTIFICATION_TYPE = "Notification-Type";
    private static final String HEADER_NOTIFICATION_DELAY = "Notification-Delay";
    private static final String HEADER_DEPTH = "Depth";
    private static final String HEADER_CALL_BACK = "Call-Back";
    private static final String HEADER_CONTENT_LOCATION = "Content-Location";
    public static final String TYPE_UPDATE = "update";
    public static final String TYPE_UPDATE_NEW_MEMBER = "update/newmember";
    public static final String TYPE_DELETE = "delete";
    public static final String TYPE_MOVE = "move";
    private String callback = null;
    private String notificationType = null;
    private int depth = -1;
    private long subsciptionLifetime = -1L;
    private int subscriptionId = -1;
    private long notificationDelay = -1L;
    private long responsedSubscriptionLifetime = -1L;
    private int responsedSubscriptionId = -1;
    private String responsedContentLocation = null;

    public SubscribeMethod() {
    }

    public SubscribeMethod(String path) {
        super(path);
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        if (callback != null && callback.length() > 0) {
            this.callback = callback;
        }
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public long getSubsciptionLifetime() {
        return this.subsciptionLifetime;
    }

    public void setSubsciptionLifetime(long subsciptionLifetime) {
        this.subsciptionLifetime = subsciptionLifetime;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(int subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setNotificationDelay(long delay) {
        this.notificationDelay = delay;
    }

    public long getNotificationDelay() {
        return this.notificationDelay;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        switch (depth) {
            case 0: 
            case 1: 
            case 0x7FFFFFFF: {
                this.depth = depth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Depth must be 0, 1 or 2147483647.");
            }
        }
    }

    public int getResponsedSubscriptionId() {
        this.checkUsed();
        return this.responsedSubscriptionId;
    }

    public long getResponsedSubscriptionLifetime() {
        this.checkUsed();
        return this.responsedSubscriptionLifetime;
    }

    public String getResponsedContentLocation() {
        this.checkUsed();
        return this.responsedContentLocation;
    }

    public String getName() {
        return "SUBSCRIBE";
    }

    public void recycle() {
        super.recycle();
        this.callback = null;
        this.depth = -1;
        this.notificationDelay = -1L;
        this.notificationType = null;
        this.responsedSubscriptionId = -1;
        this.responsedSubscriptionLifetime = -1L;
        this.subsciptionLifetime = -1L;
        this.subscriptionId = -1;
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (this.callback != null) {
            super.setRequestHeader(HEADER_CALL_BACK, this.callback);
        }
        if (this.depth > -1) {
            super.setRequestHeader(HEADER_DEPTH, this.depth == Integer.MAX_VALUE ? "infinity" : String.valueOf(this.depth));
        }
        if (this.notificationType != null) {
            super.setRequestHeader(HEADER_NOTIFICATION_TYPE, this.notificationType);
        }
        if (this.subsciptionLifetime > 0L) {
            super.setRequestHeader(HEADER_SUBSCRIPTION_LIFETIME, Long.toString(this.subsciptionLifetime));
        }
        if (this.subscriptionId > 0) {
            super.setRequestHeader(HEADER_SUBSCRIPTION_ID, Long.toString(this.subscriptionId));
        }
        if (this.notificationDelay > 0L) {
            super.setRequestHeader(HEADER_NOTIFICATION_DELAY, Long.toString(this.notificationDelay));
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        try {
            if (headerName.equalsIgnoreCase(HEADER_DEPTH)) {
                if ("infinity".equalsIgnoreCase(headerValue)) {
                    this.setDepth(Integer.MAX_VALUE);
                } else {
                    this.setDepth(Integer.parseInt(headerValue));
                }
            } else if (headerName.equals(HEADER_SUBSCRIPTION_ID)) {
                this.setSubscriptionId(Integer.parseInt(headerValue));
            } else if (headerName.equals(HEADER_SUBSCRIPTION_LIFETIME)) {
                this.setSubscriptionId(Integer.parseInt(headerValue));
            } else if (headerName.equals(HEADER_NOTIFICATION_DELAY)) {
                this.setNotificationDelay(Long.parseLong(headerValue));
            } else {
                super.setRequestHeader(headerName, headerValue);
            }
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Invalid header value '" + headerValue + "' for header " + headerName + "!");
        }
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        super.processResponseHeaders(state, conn);
        Header header = this.getResponseHeader(HEADER_SUBSCRIPTION_ID);
        if (header != null) {
            this.responsedSubscriptionId = Integer.parseInt(header.getValue());
        }
        if ((header = this.getResponseHeader(HEADER_SUBSCRIPTION_LIFETIME)) != null) {
            this.responsedSubscriptionLifetime = Long.parseLong(header.getValue());
        }
        if ((header = this.getResponseHeader(HEADER_CONTENT_LOCATION)) != null) {
            this.responsedContentLocation = header.getValue();
        }
    }
}

