/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class SearchMethod
extends XMLResponseMethodBase {
    protected String prefix = null;
    private String preloadedQuery = null;

    public SearchMethod() {
    }

    public SearchMethod(String path) {
        super(path);
    }

    public SearchMethod(String path, String query) {
        this(path);
        this.preloadedQuery = query;
    }

    public String getName() {
        return "SEARCH";
    }

    public void recycle() {
        super.recycle();
        this.prefix = null;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        if (this.preloadedQuery == null || this.preloadedQuery.trim().length() < 1) {
            return "";
        }
        return this.preloadedQuery;
    }

    public Enumeration getAllResponseURLs() {
        this.checkUsed();
        return this.getResponseURLs().elements();
    }

    public Enumeration getResponseProperties(String urlPath) {
        this.checkUsed();
        XMLResponseMethodBase.Response response = (XMLResponseMethodBase.Response)this.getResponseHashtable().get(urlPath);
        if (response != null) {
            return response.getProperties();
        }
        return new Vector().elements();
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 400 || code == 207 || code == 403 || code == 409) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
    }
}

