/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.XMLPrinter;

public class RebindMethod
extends XMLResponseMethodBase {
    public static final String NAME = "REBIND";
    private boolean overwrite = true;
    private String segment = null;
    private String href = null;

    public RebindMethod() {
    }

    public RebindMethod(String existingBinding, String newBinding) {
        super(newBinding.substring(0, newBinding.lastIndexOf(47)));
        this.href = existingBinding;
        this.segment = newBinding.substring(newBinding.lastIndexOf(47) + 1);
    }

    public String getName() {
        return NAME;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.checkNotUsed();
        this.overwrite = overwrite;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (!this.isOverwrite()) {
            super.setRequestHeader("Overwrite", "F");
        }
    }

    protected String generateRequestBody() {
        if (this.segment == null || this.href == null) {
            throw new IllegalStateException("Segment and Href must be set before calling this function.");
        }
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "rebind", 0);
        printer.writeElement("D", "segment", 0);
        printer.writeText(this.segment);
        printer.writeElement("D", "segment", 1);
        printer.writeElement("D", "href", 0);
        printer.writeText(this.href);
        printer.writeElement("D", "href", 1);
        printer.writeElement("D", "rebind", 1);
        return printer.toString();
    }

    public String getHref() {
        return this.href;
    }

    public String getSegment() {
        return this.segment;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }
}

