/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PollMethod
extends XMLResponseMethodBase {
    private static final String HEADER_SUBSCRIPTION_ID = "Subscription-Id";
    private static final String EXCHANGE_NS = "http://schemas.microsoft.com/Exchange/";
    private List subscriptionIds = new ArrayList();
    private List subscriptionsWithEvents = new ArrayList();
    private List subscriptionsWithoutEvents = new ArrayList();

    public PollMethod() {
    }

    public PollMethod(String path) {
        super(path);
    }

    public void addSubscriptionId(int id) {
        this.checkNotUsed();
        this.subscriptionIds.add(new Integer(id));
    }

    public Collection getSubscriptionsWithEvents() {
        this.checkUsed();
        return this.subscriptionsWithEvents;
    }

    public Collection getSubscriptionsWithoutEvents() {
        this.checkUsed();
        return this.subscriptionsWithoutEvents;
    }

    public String getName() {
        return "POLL";
    }

    public void recycle() {
        super.recycle();
        this.subscriptionIds.clear();
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (this.subscriptionIds.size() > 0) {
            StringBuffer b2 = new StringBuffer();
            boolean first = true;
            Iterator i2 = this.subscriptionIds.iterator();
            while (i2.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    b2.append(", ");
                }
                b2.append(i2.next());
            }
            super.addRequestHeader(HEADER_SUBSCRIPTION_ID, b2.toString());
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase(HEADER_SUBSCRIPTION_ID)) {
            StringTokenizer t = new StringTokenizer(headerValue, ", ");
            try {
                while (t.hasMoreTokens()) {
                    this.addSubscriptionId(Integer.parseInt(t.nextToken()));
                }
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Invalid header value '" + headerValue + "' for header " + headerName + "!");
            }
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        int status = this.getStatusLine().getStatusCode();
        if (status == 207) {
            this.parseXMLResponse(input);
            NodeList list = this.getResponseDocument().getDocumentElement().getElementsByTagNameNS("DAV:", "response");
            for (int i2 = 0; i2 < list.getLength(); ++i2) {
                String id;
                int l2;
                NodeList li;
                NodeList p;
                Element e2 = (Element)list.item(i2);
                NodeList s = e2.getElementsByTagNameNS("DAV:", "status");
                if (s.getLength() <= 0) continue;
                Element response = (Element)s.item(0).getParentNode();
                String statusText = DOMUtils.getTextValue((Element)s.item(0));
                if (statusText.indexOf(" 200 ") != -1) {
                    p = response.getElementsByTagNameNS(EXCHANGE_NS, "subscriptionID");
                    if (p.getLength() <= 0) continue;
                    li = ((Element)p.item(0)).getElementsByTagName("li");
                    for (l2 = 0; l2 < li.getLength(); ++l2) {
                        id = DOMUtils.getTextValue(li.item(i2));
                        this.subscriptionsWithEvents.add(Integer.getInteger(id));
                    }
                    continue;
                }
                if (statusText.indexOf(" 204 ") == -1 || (p = response.getElementsByTagNameNS(EXCHANGE_NS, "subscriptionID")).getLength() <= 0) continue;
                li = ((Element)p.item(0)).getElementsByTagName("li");
                for (l2 = 0; l2 < li.getLength(); ++l2) {
                    id = DOMUtils.getTextValue(li.item(i2));
                    this.subscriptionsWithoutEvents.add(Integer.getInteger(id));
                }
            }
        }
    }
}

