/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import jec.httpclient.protocol.Protocol;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class MoveMethod
extends XMLResponseMethodBase {
    private String destination;
    private boolean overwrite = true;

    public MoveMethod() {
    }

    public MoveMethod(String source) {
        super(source);
    }

    public MoveMethod(String source, String destination) {
        this(source);
        this.setDestination(destination);
    }

    public MoveMethod(String source, String destination, boolean overwrite) {
        this(source, destination);
        this.setOverwrite(overwrite);
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Overwrite")) {
            this.setOverwrite(!headerValue.equalsIgnoreCase("F") && !headerValue.equalsIgnoreCase("False"));
        } else if (headerName.equalsIgnoreCase("Destination")) {
            this.setDestination(headerValue);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void setDestination(String destination) {
        this.checkNotUsed();
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setOverwrite(boolean overwrite) {
        this.checkNotUsed();
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String getName() {
        return "MOVE";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        String absoluteDestination = MoveMethod.getAbsoluteDestination(conn, this.destination);
        super.setRequestHeader("Destination", absoluteDestination);
        if (!this.isOverwrite()) {
            super.setRequestHeader("Overwrite", "F");
        }
    }

    static String getAbsoluteDestination(HttpConnection conn, String absolutePathOrURL) {
        String absoluteDestination = absolutePathOrURL;
        if (absolutePathOrURL.startsWith("/")) {
            Protocol protocol = conn.getProtocol();
            StringBuffer bufDest = new StringBuffer(protocol.getScheme());
            bufDest.append("://").append(conn.getHost());
            if (conn.getPort() != protocol.getDefaultPort()) {
                bufDest.append(':').append(conn.getPort());
            }
            bufDest.append(absolutePathOrURL);
            absoluteDestination = bufDest.toString();
        }
        return absoluteDestination;
    }
}

