/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.XMLPrinter;

public class AclMethod
extends XMLResponseMethodBase {
    protected Vector aces = new Vector();

    public AclMethod() {
    }

    public AclMethod(String path) {
        super(path);
    }

    public void addAce(Ace ace) {
        this.checkNotUsed();
        this.aces.addElement(ace);
    }

    public void recycle() {
        super.recycle();
        this.aces.clear();
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "acl", 0);
        Enumeration aceList = this.aces.elements();
        while (aceList.hasMoreElements()) {
            Ace ace = (Ace)aceList.nextElement();
            if (ace.isInherited() || ace.isProtected()) continue;
            printer.writeElement("D", null, "ace", 0);
            printer.writeElement("D", null, "principal", 0);
            boolean found = false;
            String principal = ace.getPrincipal();
            String[] types = new String[]{"all", "authenticated", "unauthenticated", "property", "self"};
            for (int i2 = 0; i2 < types.length && !found; ++i2) {
                if (!types[i2].equals(principal)) continue;
                found = true;
                if ("property".equals(principal)) {
                    printer.writeElement("D", null, principal, 0);
                    PropertyName property = ace.getProperty();
                    String nsURI = property.getNamespaceURI();
                    if ("DAV:".equals(nsURI)) {
                        printer.writeElement("D", null, property.getLocalName(), 2);
                    } else {
                        printer.writeElement("Z", nsURI, property.getLocalName(), 2);
                    }
                    printer.writeElement("D", null, principal, 1);
                    continue;
                }
                printer.writeElement("D", null, principal, 2);
            }
            if (!found) {
                printer.writeElement("D", null, "href", 0);
                printer.writeText(principal);
                printer.writeElement("D", null, "href", 1);
            }
            printer.writeElement("D", null, "principal", 1);
            String positive = ace.isNegative() ? "deny" : "grant";
            printer.writeElement("D", null, positive, 0);
            Enumeration privilegeList = ace.enumeratePrivileges();
            while (privilegeList.hasMoreElements()) {
                Privilege privilege = (Privilege)privilegeList.nextElement();
                printer.writeElement("D", null, "privilege", 0);
                String nsURI = privilege.getNamespace();
                if ("DAV:".equals(nsURI)) {
                    printer.writeElement("D", null, privilege.getName(), 2);
                } else {
                    printer.writeElement("Z", nsURI, privilege.getName(), 2);
                }
                printer.writeElement("D", null, "privilege", 1);
            }
            printer.writeElement("D", null, positive, 1);
            printer.writeElement("D", null, "ace", 1);
        }
        printer.writeElement("D", "acl", 1);
        return printer.toString();
    }

    public String getName() {
        return "ACL";
    }
}

