/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jec.httpclient.HttpState;

public class WebdavState
extends HttpState {
    private static final String[] EMPTY_ARRAY = new String[0];
    protected HashMap locks = new HashMap();
    protected ArrayList lockTokens = new ArrayList();
    protected String transactionHandle = null;

    public void addLock(String uri, String value) {
        if (value == null) {
            return;
        }
        if (this.lockTokens.contains(value)) {
            return;
        }
        this.locks.put(uri, value);
        this.lockTokens.add(value);
    }

    public void removeLock(String uri, String value) {
        this.locks.remove(uri);
        int i2 = this.lockTokens.indexOf(value);
        if (i2 != -1) {
            this.lockTokens.remove(i2);
        }
    }

    public void removeLocks(String uri) {
        int i2;
        String result = (String)this.locks.remove(uri);
        if (result != null && (i2 = this.lockTokens.indexOf(result)) != -1) {
            this.lockTokens.remove(i2);
        }
    }

    public String getLock(String uri) {
        return (String)this.locks.get(uri);
    }

    public Enumeration getLocks(String uri) {
        Vector<String> result = new Vector<String>();
        String lockToken = this.getLock(uri);
        if (lockToken != null) {
            result.addElement(lockToken);
        }
        return result.elements();
    }

    public String[] getAllLocks(String uri) {
        return this.lockTokens.toArray(EMPTY_ARRAY);
    }

    public String getTransactionHandle() {
        return this.transactionHandle;
    }

    public void setTransactionHandle(String transactionHandle) {
        this.transactionHandle = transactionHandle;
    }
}

