/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.auth;

import java.security.MessageDigest;
import java.util.Map;
import jec.httpclient.Credentials;
import jec.httpclient.HttpConstants;
import jec.httpclient.UsernamePasswordCredentials;
import jec.httpclient.auth.AuthenticationException;
import jec.httpclient.auth.MalformedChallengeException;
import jec.httpclient.auth.RFC2617Scheme;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigestScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog((Class)DigestScheme.class);
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public String getID() {
        String id = this.getRealm();
        String nonce = this.getParameter("nonce");
        if (nonce != null) {
            id = id + "-" + nonce;
        }
        return id;
    }

    public DigestScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("realm missing");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("nonce missing");
        }
        this.getParameters().put("nc", "00000001");
    }

    public String getSchemeName() {
        return "digest";
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        LOG.trace((Object)"enter DigestScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException e2) {
            throw new AuthenticationException("Credentials cannot be used for digest authentication: " + credentials.getClass().getName());
        }
        this.getParameters().put("cnonce", DigestScheme.createCnonce());
        this.getParameters().put("methodname", method);
        this.getParameters().put("uri", uri);
        return DigestScheme.authenticate(usernamepassword, this.getParameters());
    }

    public static String authenticate(UsernamePasswordCredentials credentials, Map params) throws AuthenticationException {
        LOG.trace((Object)"enter DigestScheme.authenticate(UsernamePasswordCredentials, Map)");
        String digest = DigestScheme.createDigest(credentials.getUserName(), credentials.getPassword(), params);
        return "Digest " + DigestScheme.createDigestHeader(credentials.getUserName(), params, digest);
    }

    public static String createDigest(String uname, String pwd, Map params) throws AuthenticationException {
        String serverDigestValue;
        MessageDigest md5Helper;
        LOG.trace((Object)"enter DigestScheme.createDigest(String, String, Map)");
        String digAlg = "MD5";
        String uri = (String)params.get("uri");
        String realm = (String)params.get("realm");
        String nonce = (String)params.get("nonce");
        String nc = (String)params.get("nc");
        String cnonce = (String)params.get("cnonce");
        String qop = (String)params.get("qop");
        String method = (String)params.get("methodname");
        String algorithm = (String)params.get("algorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if (qop != null) {
            qop = "auth";
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e2) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String a1 = null;
        if (algorithm.equals("MD5")) {
            a1 = uname + ":" + realm + ":" + pwd;
        } else if (algorithm.equals("MD5-sess")) {
            String tmp = DigestScheme.encode(md5Helper.digest(HttpConstants.getContentBytes(uname + ":" + realm + ":" + pwd)));
            a1 = tmp + ":" + nonce + ":" + cnonce;
        } else {
            LOG.warn((Object)("Unhandled algorithm " + algorithm + " requested"));
            a1 = uname + ":" + realm + ":" + pwd;
        }
        String md5a1 = DigestScheme.encode(md5Helper.digest(HttpConstants.getContentBytes(a1)));
        String a2 = method + ":" + uri;
        String md5a2 = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(a2)));
        if (qop == null) {
            LOG.debug((Object)"Using null qop method");
            serverDigestValue = md5a1 + ":" + nonce + ":" + md5a2;
        } else {
            LOG.debug((Object)("Using qop method " + qop));
            serverDigestValue = md5a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        }
        String serverDigest = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(serverDigestValue)));
        return serverDigest;
    }

    public static String createDigestHeader(String uname, Map params, String digest) {
        LOG.trace((Object)"enter DigestScheme.createDigestHeader(String, Map, String)");
        StringBuffer sb = new StringBuffer();
        String uri = (String)params.get("uri");
        String realm = (String)params.get("realm");
        String nonce = (String)params.get("nonce");
        String nc = (String)params.get("nc");
        String cnonce = (String)params.get("cnonce");
        String opaque = (String)params.get("opaque");
        String response = digest;
        String qop = (String)params.get("qop");
        String algorithm = (String)params.get("algorithm");
        if (qop != null) {
            qop = "auth";
        }
        sb.append("username=\"" + uname + "\"").append(", realm=\"" + realm + "\"").append(", nonce=\"" + nonce + "\"").append(", uri=\"" + uri + "\"").append(qop == null ? "" : ", qop=\"" + qop + "\"").append(algorithm == null ? "" : ", algorithm=\"" + algorithm + "\"").append(qop == null ? "" : ", nc=" + nc).append(qop == null ? "" : ", cnonce=\"" + cnonce + "\"").append(", response=\"" + response + "\"").append(opaque == null ? "" : ", opaque=\"" + opaque + "\"");
        return sb.toString();
    }

    private static String encode(byte[] binaryData) {
        LOG.trace((Object)"enter DigestScheme.encode(byte[])");
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i2 = 0; i2 < 16; ++i2) {
            int low = binaryData[i2] & 0xF;
            int high = (binaryData[i2] & 0xF0) >> 4;
            buffer[i2 * 2] = HEXADECIMAL[high];
            buffer[i2 * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    public static String createCnonce() throws AuthenticationException {
        MessageDigest md5Helper;
        LOG.trace((Object)"enter DigestScheme.createCnonce()");
        String digAlg = "MD5";
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e2) {
            throw new AuthenticationException("Unsupported algorithm in HTTP Digest authentication: MD5");
        }
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = DigestScheme.encode(md5Helper.digest(HttpConstants.getBytes(cnonce)));
        return cnonce;
    }
}

