/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Wire {
    private static final Log WIRE_LOG = LogFactory.getLog((String)"httpclient.wire");

    Wire() {
    }

    private static void wire(String header, InputStream instream) throws IOException {
        int ch;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(instream, "US-ASCII");
        }
        catch (UnsupportedEncodingException e2) {
            reader = new InputStreamReader(instream);
        }
        StringBuffer buffer = new StringBuffer();
        while ((ch = ((Reader)reader).read()) != -1) {
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                WIRE_LOG.debug((Object)buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append("\"");
            buffer.insert(0, "\"");
            buffer.insert(0, header);
            WIRE_LOG.debug((Object)buffer.toString());
        }
    }

    public static final boolean enabled() {
        return WIRE_LOG.isDebugEnabled();
    }

    public static final void output(InputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.wire(">> ", outstream);
    }

    public static final void input(InputStream instream) throws IOException {
        if (instream == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.wire("<< ", instream);
    }

    public static final void output(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.wire(">> ", new ByteArrayInputStream(b2, off, len));
    }

    public static final void input(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.wire("<< ", new ByteArrayInputStream(b2, off, len));
    }

    public static final void output(byte[] b2) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.wire(">> ", new ByteArrayInputStream(b2));
    }

    public static final void input(byte[] b2) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.wire("<< ", new ByteArrayInputStream(b2));
    }

    public static final void output(int b2) throws IOException {
        Wire.output(new byte[]{(byte)b2});
    }

    public static final void input(int b2) throws IOException {
        Wire.input(new byte[]{(byte)b2});
    }

    public static final void output(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        Wire.output(s.getBytes());
    }

    public static final void input(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        Wire.input(s.getBytes());
    }
}

