/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.persistence.hibernate;

import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReflectionUtil {
    ReflectionUtil() {
    }

    static <T> T getValue(String fieldName, Object object) {
        Class<?> clazz = object.getClass();
        Object value = null;
        try {
            Field field = ReflectionUtil.getField(clazz, fieldName);
            field.setAccessible(true);
            value = field.get(object);
        }
        catch (SecurityException ex) {
            ReflectionUtil.handleReflectionException(ex, clazz, fieldName);
        }
        catch (IllegalArgumentException ex) {
            ReflectionUtil.handleReflectionException(ex, clazz, fieldName);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtil.handleReflectionException(ex, clazz, fieldName);
        }
        return (T)value;
    }

    public static Field getField(Class<?> clazz, String name) {
        for (Class<?> currentClazz = clazz; !Object.class.equals(currentClazz) && currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClazz.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName())) continue;
                return field;
            }
        }
        throw new IllegalStateException("The " + clazz.getSimpleName() + " class does not have any " + name + " field");
    }

    private static void handleReflectionException(Exception ex, Class<? extends Object> clazz, String fieldName) {
        throw new IllegalStateException("Unexpected reflection exception while getting " + fieldName + " field of class " + clazz.getSimpleName() + ": " + ex.getMessage(), ex);
    }
}

