/*
 * Decompiled with CFR 0.152.
 */
package com.javaetmoi.core.persistence.hibernate;

import com.javaetmoi.core.persistence.hibernate.LazyLoadingUtil;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.hibernate.ejb.HibernateEntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaLazyLoadingUtil {
    private JpaLazyLoadingUtil() {
    }

    public static <E> Collection<E> deepHydrate(EntityManager currentEntityManager, Collection<E> entities) {
        if (currentEntityManager instanceof HibernateEntityManager) {
            HibernateEntityManager entityManager = (HibernateEntityManager)currentEntityManager;
            return LazyLoadingUtil.deepHydrate(entityManager.getSession(), entities);
        }
        if (currentEntityManager instanceof org.hibernate.jpa.HibernateEntityManager) {
            HibernateEntityManager entityManager = (HibernateEntityManager)currentEntityManager;
            return LazyLoadingUtil.deepHydrate(entityManager.getSession(), entities);
        }
        throw new RuntimeException("Only the Hibername implementation of JPA is currently supported");
    }

    public static <E> E deepHydrate(EntityManager currentEntityManager, E entity) {
        if (currentEntityManager instanceof HibernateEntityManager) {
            HibernateEntityManager entityManager = (HibernateEntityManager)currentEntityManager;
            return LazyLoadingUtil.deepHydrate(entityManager.getSession(), entity);
        }
        if (currentEntityManager instanceof org.hibernate.jpa.HibernateEntityManager) {
            org.hibernate.jpa.HibernateEntityManager entityManager = (org.hibernate.jpa.HibernateEntityManager)currentEntityManager;
            return LazyLoadingUtil.deepHydrate(entityManager.getSession(), entity);
        }
        throw new RuntimeException("Only the Hibername implementation of JPA is currently supported");
    }
}

