/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.device;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceName {
    private static final String DEVICE_JSON_URL = "https://raw.githubusercontent.com/jaredrummler/AndroidDeviceNames/master/json/devices/%s.json";
    private static final String SHARED_PREF_NAME = "device_names";

    public static Request with(Context context) {
        return new Request(context.getApplicationContext());
    }

    public static String getDeviceName() {
        return DeviceName.getDeviceName(Build.DEVICE, Build.MODEL, DeviceName.capitalize(Build.MODEL));
    }

    public static String getDeviceName(String codename, String fallback) {
        return DeviceName.getDeviceName(codename, codename, fallback);
    }

    public static String getDeviceName(String codename, String model, String fallback) {
        if (codename != null && codename.equals("walleye")) {
            return "Pixel 2";
        }
        if (codename != null && codename.equals("taimen")) {
            return "Pixel 2 XL";
        }
        if (codename != null && codename.equals("blueline")) {
            return "Pixel 3";
        }
        if (codename != null && codename.equals("crosshatch")) {
            return "Pixel 3 XL";
        }
        if (codename != null && codename.equals("sargo")) {
            return "Pixel 3a";
        }
        if (codename != null && codename.equals("bonito")) {
            return "Pixel 3a XL";
        }
        if (codename != null && codename.equals("HWBND-H") || model != null && (model.equals("BND-L21") || model.equals("BND-L24") || model.equals("BND-L31"))) {
            return "Honor 7X";
        }
        if (codename != null && codename.equals("HWBKL") || model != null && (model.equals("BKL-L04") || model.equals("BKL-L09"))) {
            return "Honor View 10";
        }
        if (codename != null && codename.equals("HWALP") || model != null && (model.equals("ALP-AL00") || model.equals("ALP-L09") || model.equals("ALP-L29") || model.equals("ALP-TL00"))) {
            return "Mate 10";
        }
        if (codename != null && codename.equals("HWMHA") || model != null && (model.equals("MHA-AL00") || model.equals("MHA-L09") || model.equals("MHA-L29") || model.equals("MHA-TL00"))) {
            return "Mate 9";
        }
        if (codename != null && codename.equals("angler")) {
            return "Nexus 6P";
        }
        if (codename != null && codename.equals("h1") || model != null && (model.equals("LG-F700K") || model.equals("LG-F700L") || model.equals("LG-F700S") || model.equals("LG-H820") || model.equals("LG-H820PR") || model.equals("LG-H830") || model.equals("LG-H831") || model.equals("LG-H850") || model.equals("LG-H858") || model.equals("LG-H860") || model.equals("LG-H868") || model.equals("LGAS992") || model.equals("LGLS992") || model.equals("LGUS992") || model.equals("RS988") || model.equals("VS987"))) {
            return "LG G5";
        }
        if (codename != null && codename.equals("lucye") || model != null && (model.equals("LG-AS993") || model.equals("LG-H870") || model.equals("LG-H870AR") || model.equals("LG-H870DS") || model.equals("LG-H870I") || model.equals("LG-H870S") || model.equals("LG-H871") || model.equals("LG-H871S") || model.equals("LG-H872") || model.equals("LG-H872PR") || model.equals("LG-H873") || model.equals("LG-LS993") || model.equals("LGM-G600K") || model.equals("LGM-G600L") || model.equals("LGM-G600S") || model.equals("LGUS997") || model.equals("VS988"))) {
            return "LG G6";
        }
        if (codename != null && codename.equals("flashlmdd") || model != null && (model.equals("LM-V500") || model.equals("LM-V500N"))) {
            return "LG V50 ThinQ";
        }
        if (codename != null && codename.equals("mako")) {
            return "Nexus 4";
        }
        if (codename != null && codename.equals("hammerhead")) {
            return "Nexus 5";
        }
        if (codename != null && codename.equals("bullhead")) {
            return "Nexus 5X";
        }
        if (codename != null && codename.equals("griffin") || model != null && (model.equals("XT1650") || model.equals("XT1650-05"))) {
            return "Moto Z";
        }
        if (codename != null && codename.equals("shamu")) {
            return "Nexus 6";
        }
        if (codename != null && (codename.equals("RHD") || codename.equals("ROO") || codename.equals("ROON_sprout") || codename.equals("ROO_sprout"))) {
            return "Nokia 3.1 Plus";
        }
        if (codename != null && codename.equals("CTL_sprout")) {
            return "Nokia 7.1";
        }
        if (codename != null && codename.equals("OnePlus6") || model != null && model.equals("ONEPLUS A6003")) {
            return "OnePlus 6";
        }
        if (codename != null && (codename.equals("OnePlus6T") || codename.equals("OnePlus6TSingle")) || model != null && model.equals("ONEPLUS A6013")) {
            return "OnePlus 6T";
        }
        if (codename != null && codename.equals("OnePlus7") || model != null && model.equals("GM1905")) {
            return "OnePlus 7";
        }
        if (codename != null && (codename.equals("OnePlus7Pro") || codename.equals("OnePlus7ProTMO")) || model != null && (model.equals("GM1915") || model.equals("GM1917"))) {
            return "OnePlus 7 Pro";
        }
        if (codename != null && codename.equals("a50") || model != null && (model.equals("SM-A505F") || model.equals("SM-A505FM") || model.equals("SM-A505FN") || model.equals("SM-A505G") || model.equals("SM-A505GN") || model.equals("SM-A505GT") || model.equals("SM-A505N") || model.equals("SM-A505U") || model.equals("SM-A505W") || model.equals("SM-A505YN"))) {
            return "Galaxy A50";
        }
        if (codename != null && (codename.equals("a6elteaio") || codename.equals("a6elteatt") || codename.equals("a6eltemtr") || codename.equals("a6eltespr") || codename.equals("a6eltetmo") || codename.equals("a6elteue") || codename.equals("a6lte") || codename.equals("a6lteks")) || model != null && (model.equals("SM-A600A") || model.equals("SM-A600AZ") || model.equals("SM-A600F") || model.equals("SM-A600FN") || model.equals("SM-A600G") || model.equals("SM-A600GN") || model.equals("SM-A600N") || model.equals("SM-A600P") || model.equals("SM-A600T") || model.equals("SM-A600T1") || model.equals("SM-A600U"))) {
            return "Galaxy A6";
        }
        if (codename != null && (codename.equals("SC-01J") || codename.equals("SCV34") || codename.equals("gracelte") || codename.equals("graceltektt") || codename.equals("graceltelgt") || codename.equals("gracelteskt") || codename.equals("graceqlteacg") || codename.equals("graceqlteatt") || codename.equals("graceqltebmc") || codename.equals("graceqltechn") || codename.equals("graceqltedcm") || codename.equals("graceqltelra") || codename.equals("graceqltespr") || codename.equals("graceqltetfnvzw") || codename.equals("graceqltetmo") || codename.equals("graceqlteue") || codename.equals("graceqlteusc") || codename.equals("graceqltevzw")) || model != null && (model.equals("SAMSUNG-SM-N930A") || model.equals("SC-01J") || model.equals("SCV34") || model.equals("SGH-N037") || model.equals("SM-N9300") || model.equals("SM-N930F") || model.equals("SM-N930K") || model.equals("SM-N930L") || model.equals("SM-N930P") || model.equals("SM-N930R4") || model.equals("SM-N930R6") || model.equals("SM-N930R7") || model.equals("SM-N930S") || model.equals("SM-N930T") || model.equals("SM-N930U") || model.equals("SM-N930V") || model.equals("SM-N930VL") || model.equals("SM-N930W8") || model.equals("SM-N930X"))) {
            return "Galaxy Note7";
        }
        if (codename != null && (codename.equals("SC-01K") || codename.equals("SCV37") || codename.equals("greatlte") || codename.equals("greatlteks") || codename.equals("greatqlte") || codename.equals("greatqltechn") || codename.equals("greatqltecmcc") || codename.equals("greatqltecs") || codename.equals("greatqlteue")) || model != null && (model.equals("SC-01K") || model.equals("SCV37") || model.equals("SM-N9500") || model.equals("SM-N9508") || model.equals("SM-N950F") || model.equals("SM-N950N") || model.equals("SM-N950U") || model.equals("SM-N950U1") || model.equals("SM-N950W") || model.equals("SM-N950XN"))) {
            return "Galaxy Note8";
        }
        if (codename != null && (codename.equals("SC-01L") || codename.equals("SCV40") || codename.equals("crownlte") || codename.equals("crownlteks") || codename.equals("crownqltechn") || codename.equals("crownqltecs") || codename.equals("crownqltesq") || codename.equals("crownqlteue")) || model != null && (model.equals("SC-01L") || model.equals("SCV40") || model.equals("SM-N9600") || model.equals("SM-N960F") || model.equals("SM-N960N") || model.equals("SM-N960U") || model.equals("SM-N960U1") || model.equals("SM-N960W"))) {
            return "Galaxy Note9";
        }
        if (codename != null && (codename.equals("SC-03L") || codename.equals("SCV41") || codename.equals("beyond1") || codename.equals("beyond1q")) || model != null && (model.equals("SC-03L") || model.equals("SCV41") || model.equals("SM-G9730") || model.equals("SM-G9738") || model.equals("SM-G973F") || model.equals("SM-G973N") || model.equals("SM-G973U") || model.equals("SM-G973U1") || model.equals("SM-G973W"))) {
            return "Galaxy S10";
        }
        if (codename != null && (codename.equals("SC-04L") || codename.equals("SCV42") || codename.equals("beyond2") || codename.equals("beyond2q")) || model != null && (model.equals("SC-04L") || model.equals("SCV42") || model.equals("SM-G9750") || model.equals("SM-G9758") || model.equals("SM-G975F") || model.equals("SM-G975N") || model.equals("SM-G975U") || model.equals("SM-G975U1") || model.equals("SM-G975W"))) {
            return "Galaxy S10+";
        }
        if (codename != null && (codename.equals("beyond0") || codename.equals("beyond0q")) || model != null && (model.equals("SM-G9700") || model.equals("SM-G9708") || model.equals("SM-G970F") || model.equals("SM-G970N") || model.equals("SM-G970U") || model.equals("SM-G970U1") || model.equals("SM-G970W"))) {
            return "Galaxy S10e";
        }
        if (codename != null && (codename.equals("SC-04F") || codename.equals("SCL23") || codename.equals("k3g") || codename.equals("klte") || codename.equals("klteMetroPCS") || codename.equals("klteacg") || codename.equals("klteaio") || codename.equals("klteatt") || codename.equals("kltecan") || codename.equals("klteduoszn") || codename.equals("kltektt") || codename.equals("kltelgt") || codename.equals("kltelra") || codename.equals("klteskt") || codename.equals("kltespr") || codename.equals("kltetfnvzw") || codename.equals("kltetmo") || codename.equals("klteusc") || codename.equals("kltevzw") || codename.equals("kwifi") || codename.equals("lentisltektt") || codename.equals("lentisltelgt") || codename.equals("lentislteskt")) || model != null && (model.equals("SAMSUNG-SM-G900A") || model.equals("SAMSUNG-SM-G900AZ") || model.equals("SC-04F") || model.equals("SCL23") || model.equals("SM-G9006W") || model.equals("SM-G9008W") || model.equals("SM-G9009W") || model.equals("SM-G900F") || model.equals("SM-G900FQ") || model.equals("SM-G900H") || model.equals("SM-G900I") || model.equals("SM-G900K") || model.equals("SM-G900L") || model.equals("SM-G900M") || model.equals("SM-G900MD") || model.equals("SM-G900P") || model.equals("SM-G900R4") || model.equals("SM-G900R6") || model.equals("SM-G900R7") || model.equals("SM-G900S") || model.equals("SM-G900T") || model.equals("SM-G900T1") || model.equals("SM-G900T3") || model.equals("SM-G900T4") || model.equals("SM-G900V") || model.equals("SM-G900W8") || model.equals("SM-G900X") || model.equals("SM-G906K") || model.equals("SM-G906L") || model.equals("SM-G906S") || model.equals("SM-S903VL"))) {
            return "Galaxy S5";
        }
        if (codename != null && (codename.equals("s5neolte") || codename.equals("s5neoltecan")) || model != null && (model.equals("SM-G903F") || model.equals("SM-G903M") || model.equals("SM-G903W"))) {
            return "Galaxy S5 Neo";
        }
        if (codename != null && (codename.equals("SC-05G") || codename.equals("zeroflte") || codename.equals("zeroflteacg") || codename.equals("zeroflteaio") || codename.equals("zeroflteatt") || codename.equals("zerofltebmc") || codename.equals("zerofltechn") || codename.equals("zerofltectc") || codename.equals("zerofltektt") || codename.equals("zerofltelgt") || codename.equals("zerofltelra") || codename.equals("zerofltemtr") || codename.equals("zeroflteskt") || codename.equals("zerofltespr") || codename.equals("zerofltetfnvzw") || codename.equals("zerofltetmo") || codename.equals("zeroflteusc") || codename.equals("zerofltevzw")) || model != null && (model.equals("SAMSUNG-SM-G920A") || model.equals("SAMSUNG-SM-G920AZ") || model.equals("SC-05G") || model.equals("SM-G9200") || model.equals("SM-G9208") || model.equals("SM-G9209") || model.equals("SM-G920F") || model.equals("SM-G920I") || model.equals("SM-G920K") || model.equals("SM-G920L") || model.equals("SM-G920P") || model.equals("SM-G920R4") || model.equals("SM-G920R6") || model.equals("SM-G920R7") || model.equals("SM-G920S") || model.equals("SM-G920T") || model.equals("SM-G920T1") || model.equals("SM-G920V") || model.equals("SM-G920W8") || model.equals("SM-G920X") || model.equals("SM-S906L") || model.equals("SM-S907VL"))) {
            return "Galaxy S6";
        }
        if (codename != null && (codename.equals("404SC") || codename.equals("SC-04G") || codename.equals("SCV31") || codename.equals("zerolte") || codename.equals("zerolteacg") || codename.equals("zerolteatt") || codename.equals("zeroltebmc") || codename.equals("zeroltechn") || codename.equals("zeroltektt") || codename.equals("zeroltelra") || codename.equals("zerolteskt") || codename.equals("zeroltespr") || codename.equals("zeroltetmo") || codename.equals("zerolteusc") || codename.equals("zeroltevzw")) || model != null && (model.equals("404SC") || model.equals("SAMSUNG-SM-G925A") || model.equals("SC-04G") || model.equals("SCV31") || model.equals("SM-G9250") || model.equals("SM-G925I") || model.equals("SM-G925K") || model.equals("SM-G925P") || model.equals("SM-G925R4") || model.equals("SM-G925R6") || model.equals("SM-G925R7") || model.equals("SM-G925S") || model.equals("SM-G925T") || model.equals("SM-G925V") || model.equals("SM-G925W8") || model.equals("SM-G925X"))) {
            return "Galaxy S6 Edge";
        }
        if (codename != null && (codename.equals("zenlte") || codename.equals("zenlteatt") || codename.equals("zenltebmc") || codename.equals("zenltechn") || codename.equals("zenltektt") || codename.equals("zenltekx") || codename.equals("zenltelgt") || codename.equals("zenlteskt") || codename.equals("zenltespr") || codename.equals("zenltetmo") || codename.equals("zenlteusc") || codename.equals("zenltevzw")) || model != null && (model.equals("SAMSUNG-SM-G928A") || model.equals("SM-G9280") || model.equals("SM-G9287C") || model.equals("SM-G928C") || model.equals("SM-G928G") || model.equals("SM-G928I") || model.equals("SM-G928K") || model.equals("SM-G928L") || model.equals("SM-G928N0") || model.equals("SM-G928P") || model.equals("SM-G928R4") || model.equals("SM-G928S") || model.equals("SM-G928T") || model.equals("SM-G928V") || model.equals("SM-G928W8") || model.equals("SM-G928X"))) {
            return "Galaxy S6 Edge+";
        }
        if (codename != null && (codename.equals("herolte") || codename.equals("heroltebmc") || codename.equals("heroltektt") || codename.equals("heroltelgt") || codename.equals("herolteskt") || codename.equals("heroqlteacg") || codename.equals("heroqlteaio") || codename.equals("heroqlteatt") || codename.equals("heroqltecctvzw") || codename.equals("heroqltechn") || codename.equals("heroqltelra") || codename.equals("heroqltemtr") || codename.equals("heroqltespr") || codename.equals("heroqltetfnvzw") || codename.equals("heroqltetmo") || codename.equals("heroqlteue") || codename.equals("heroqlteusc") || codename.equals("heroqltevzw")) || model != null && (model.equals("SAMSUNG-SM-G930A") || model.equals("SAMSUNG-SM-G930AZ") || model.equals("SM-G9300") || model.equals("SM-G9308") || model.equals("SM-G930F") || model.equals("SM-G930K") || model.equals("SM-G930L") || model.equals("SM-G930P") || model.equals("SM-G930R4") || model.equals("SM-G930R6") || model.equals("SM-G930R7") || model.equals("SM-G930S") || model.equals("SM-G930T") || model.equals("SM-G930T1") || model.equals("SM-G930U") || model.equals("SM-G930V") || model.equals("SM-G930VC") || model.equals("SM-G930VL") || model.equals("SM-G930W8") || model.equals("SM-G930X"))) {
            return "Galaxy S7";
        }
        if (codename != null && (codename.equals("SC-02H") || codename.equals("SCV33") || codename.equals("hero2lte") || codename.equals("hero2ltebmc") || codename.equals("hero2ltektt") || codename.equals("hero2lteskt") || codename.equals("hero2qlteatt") || codename.equals("hero2qltecctvzw") || codename.equals("hero2qltespr") || codename.equals("hero2qltetmo") || codename.equals("hero2qlteusc") || codename.equals("hero2qltevzw")) || model != null && (model.equals("SAMSUNG-SM-G935A") || model.equals("SC-02H") || model.equals("SCV33") || model.equals("SM-G935K") || model.equals("SM-G935P") || model.equals("SM-G935R4") || model.equals("SM-G935S") || model.equals("SM-G935T") || model.equals("SM-G935V") || model.equals("SM-G935VC") || model.equals("SM-G935W8") || model.equals("SM-G935X"))) {
            return "Galaxy S7 Edge";
        }
        if (codename != null && (codename.equals("SC-02J") || codename.equals("SCV36") || codename.equals("dreamlte") || codename.equals("dreamlteks") || codename.equals("dreamqltecan") || codename.equals("dreamqltechn") || codename.equals("dreamqltecmcc") || codename.equals("dreamqltesq") || codename.equals("dreamqlteue")) || model != null && (model.equals("SC-02J") || model.equals("SCV36") || model.equals("SM-G9500") || model.equals("SM-G9508") || model.equals("SM-G950F") || model.equals("SM-G950N") || model.equals("SM-G950U") || model.equals("SM-G950U1") || model.equals("SM-G950W"))) {
            return "Galaxy S8";
        }
        if (codename != null && (codename.equals("SC-03J") || codename.equals("SCV35") || codename.equals("dream2lte") || codename.equals("dream2lteks") || codename.equals("dream2qltecan") || codename.equals("dream2qltechn") || codename.equals("dream2qltesq") || codename.equals("dream2qlteue")) || model != null && (model.equals("SC-03J") || model.equals("SCV35") || model.equals("SM-G9550") || model.equals("SM-G955F") || model.equals("SM-G955N") || model.equals("SM-G955U") || model.equals("SM-G955U1") || model.equals("SM-G955W"))) {
            return "Galaxy S8+";
        }
        if (codename != null && (codename.equals("SC-02K") || codename.equals("SCV38") || codename.equals("starlte") || codename.equals("starlteks") || codename.equals("starqltechn") || codename.equals("starqltecmcc") || codename.equals("starqltecs") || codename.equals("starqltesq") || codename.equals("starqlteue")) || model != null && (model.equals("SC-02K") || model.equals("SCV38") || model.equals("SM-G9600") || model.equals("SM-G9608") || model.equals("SM-G960F") || model.equals("SM-G960N") || model.equals("SM-G960U") || model.equals("SM-G960U1") || model.equals("SM-G960W"))) {
            return "Galaxy S9";
        }
        if (codename != null && (codename.equals("SC-03K") || codename.equals("SCV39") || codename.equals("star2lte") || codename.equals("star2lteks") || codename.equals("star2qltechn") || codename.equals("star2qltecs") || codename.equals("star2qltesq") || codename.equals("star2qlteue")) || model != null && (model.equals("SC-03K") || model.equals("SCV39") || model.equals("SM-G9650") || model.equals("SM-G965F") || model.equals("SM-G965N") || model.equals("SM-G965U") || model.equals("SM-G965U1") || model.equals("SM-G965W"))) {
            return "Galaxy S9+";
        }
        if (codename != null && (codename.equals("802SO") || codename.equals("J8110") || codename.equals("J8170") || codename.equals("J9110") || codename.equals("SO-03L") || codename.equals("SOV40")) || model != null && (model.equals("802SO") || model.equals("J8110") || model.equals("J8170") || model.equals("J9110") || model.equals("SO-03L") || model.equals("SOV40"))) {
            return "Xperia 1";
        }
        if (codename != null && (codename.equals("I3113") || codename.equals("I3123") || codename.equals("I4113") || codename.equals("I4193")) || model != null && (model.equals("I3113") || model.equals("I3123") || model.equals("I4113") || model.equals("I4193"))) {
            return "Xperia 10";
        }
        if (codename != null && (codename.equals("I3213") || codename.equals("I3223") || codename.equals("I4213") || codename.equals("I4293")) || model != null && (model.equals("I3213") || model.equals("I3223") || model.equals("I4213") || model.equals("I4293"))) {
            return "Xperia 10 Plus";
        }
        if (codename != null && (codename.equals("702SO") || codename.equals("H8216") || codename.equals("H8266") || codename.equals("H8276") || codename.equals("H8296") || codename.equals("SO-03K") || codename.equals("SOV37")) || model != null && (model.equals("702SO") || model.equals("H8216") || model.equals("H8266") || model.equals("H8276") || model.equals("H8296") || model.equals("SO-03K") || model.equals("SOV37"))) {
            return "Xperia XZ2";
        }
        if (codename != null && (codename.equals("H8116") || codename.equals("H8166") || codename.equals("SO-04K") || codename.equals("SOV38")) || model != null && (model.equals("H8116") || model.equals("H8166") || model.equals("SO-04K") || model.equals("SOV38"))) {
            return "Xperia XZ2 Premium";
        }
        if (codename != null && (codename.equals("801SO") || codename.equals("H8416") || codename.equals("H9436") || codename.equals("H9493") || codename.equals("SO-01L") || codename.equals("SOV39")) || model != null && (model.equals("801SO") || model.equals("H8416") || model.equals("H9436") || model.equals("H9493") || model.equals("SO-01L") || model.equals("SOV39"))) {
            return "Xperia XZ3";
        }
        return fallback;
    }

    @WorkerThread
    public static DeviceInfo getDeviceInfo(Context context) {
        return DeviceName.getDeviceInfo(context.getApplicationContext(), Build.DEVICE, Build.MODEL);
    }

    @WorkerThread
    public static DeviceInfo getDeviceInfo(Context context, String codename) {
        return DeviceName.getDeviceInfo(context, codename, null);
    }

    @WorkerThread
    public static DeviceInfo getDeviceInfo(Context context, String codename, String model) {
        String key;
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_NAME, 0);
        String savedJson = prefs.getString(key = String.format("%s:%s", codename, model), null);
        if (savedJson != null) {
            try {
                return new DeviceInfo(new JSONObject(savedJson));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        int ret = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        boolean isConnectedToNetwork = false;
        if (ret == 0) {
            ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                isConnectedToNetwork = true;
            }
        } else {
            isConnectedToNetwork = true;
        }
        if (isConnectedToNetwork) {
            try {
                String url = String.format(DEVICE_JSON_URL, codename.toLowerCase(Locale.ENGLISH));
                String jsonString = DeviceName.downloadJson(url);
                JSONArray jsonArray = new JSONArray(jsonString);
                int len = jsonArray.length();
                for (int i = 0; i < len; ++i) {
                    JSONObject json = jsonArray.getJSONObject(i);
                    DeviceInfo info = new DeviceInfo(json);
                    if ((!codename.equalsIgnoreCase(info.codename) || model != null) && (!codename.equalsIgnoreCase(info.codename) || !model.equalsIgnoreCase(info.model))) continue;
                    SharedPreferences.Editor editor = prefs.edit();
                    editor.putString(key, json.toString());
                    editor.apply();
                    return info;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (codename.equals(Build.DEVICE) && Build.MODEL.equals(model)) {
            return new DeviceInfo(Build.MANUFACTURER, DeviceName.getDeviceName(), codename, model);
        }
        return new DeviceInfo(null, null, codename, model);
    }

    private static String capitalize(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] arr = str.toCharArray();
        boolean capitalizeNext = true;
        String phrase = "";
        for (char c : arr) {
            if (capitalizeNext && Character.isLetter(c)) {
                phrase = phrase + Character.toUpperCase(c);
                capitalizeNext = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                capitalizeNext = true;
            }
            phrase = phrase + c;
        }
        return phrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private static String downloadJson(String myurl) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = null;){
            URL url = new URL(myurl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                String line;
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            }
            String string = sb.toString();
            return string;
        }
    }

    public static final class DeviceInfo {
        public final String manufacturer;
        public final String marketName;
        public final String codename;
        public final String model;

        public DeviceInfo(String manufacturer, String marketName, String codename, String model) {
            this.manufacturer = manufacturer;
            this.marketName = marketName;
            this.codename = codename;
            this.model = model;
        }

        private DeviceInfo(JSONObject jsonObject) throws JSONException {
            this.manufacturer = jsonObject.getString("manufacturer");
            this.marketName = jsonObject.getString("market_name");
            this.codename = jsonObject.getString("codename");
            this.model = jsonObject.getString("model");
        }

        public String getName() {
            if (!TextUtils.isEmpty((CharSequence)this.marketName)) {
                return this.marketName;
            }
            return DeviceName.capitalize(this.model);
        }
    }

    public static interface Callback {
        public void onFinished(DeviceInfo var1, Exception var2);
    }

    public static final class Request {
        final Context context;
        final Handler handler;
        String codename;
        String model;

        private Request(Context ctx) {
            this.context = ctx;
            this.handler = new Handler(ctx.getMainLooper());
        }

        public Request setCodename(String codename) {
            this.codename = codename;
            return this;
        }

        public Request setModel(String model) {
            this.model = model;
            return this;
        }

        public void request(Callback callback) {
            if (this.codename == null && this.model == null) {
                this.codename = Build.DEVICE;
                this.model = Build.MODEL;
            }
            GetDeviceRunnable runnable = new GetDeviceRunnable(callback);
            if (Looper.myLooper() == Looper.getMainLooper()) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }

        private final class GetDeviceRunnable
        implements Runnable {
            final Callback callback;
            DeviceInfo deviceInfo;
            Exception error;

            public GetDeviceRunnable(Callback callback) {
                this.callback = callback;
            }

            @Override
            public void run() {
                try {
                    this.deviceInfo = DeviceName.getDeviceInfo(Request.this.context, Request.this.codename, Request.this.model);
                }
                catch (Exception e) {
                    this.error = e;
                }
                Request.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        GetDeviceRunnable.this.callback.onFinished(GetDeviceRunnable.this.deviceInfo, GetDeviceRunnable.this.error);
                    }
                });
            }
        }
    }
}

