/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.utils;

import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.core.view.ViewCompat;
import com.jantursky.debugger.interfaces.GlobalViewListener;

public class ViewUtils {
    private static final String TAG = ViewUtils.class.getSimpleName();

    public static void addListener(final View view, final GlobalViewListener listener) {
        if (view != null && ViewCompat.isAttachedToWindow((View)view)) {
            if (listener != null) {
                listener.onGlobalLayout(view.getMeasuredWidth(), view.getMeasuredHeight());
            }
        } else {
            view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (view != null && listener != null) {
                        if (Build.VERSION.SDK_INT >= 16) {
                            view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                        listener.onGlobalLayout(view.getWidth(), view.getHeight());
                    }
                }
            });
        }
    }
}

