/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static final String TAG = JsonUtils.class.getSimpleName();

    public static boolean isJSONObjectValid(String test) {
        try {
            new JSONObject(test);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static boolean isJSONArrayValid(String test) {
        try {
            new JSONArray(test);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static String getIndentedText(String text) {
        return JsonUtils.getIndentedText(text, false);
    }

    public static String getIndentedText(String text, boolean sortAlphabetically) {
        if (JsonUtils.isJSONObjectValid(text)) {
            try {
                JSONObject jsonObject = new JSONObject(text);
                if (sortAlphabetically) {
                    jsonObject = JsonUtils.sortAlphabetically(jsonObject);
                }
                return jsonObject.toString(3);
            }
            catch (JSONException jsonObject) {}
        } else if (JsonUtils.isJSONArrayValid(text)) {
            try {
                JSONArray jsonArray = new JSONArray(text);
                if (sortAlphabetically) {
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        if (!(jsonArray.opt(i) instanceof JSONObject)) continue;
                        jsonArray.put(i, (Object)JsonUtils.sortAlphabetically((JSONObject)jsonArray.opt(i)));
                    }
                }
                return jsonArray.toString(3);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return text;
    }

    private static JSONObject sortAlphabetically(JSONObject jsonObject) {
        ArrayList<String> jsonKeys = new ArrayList<String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.opt(key) instanceof JSONObject) {
                try {
                    jsonObject.put(key, (Object)JsonUtils.sortAlphabetically((JSONObject)jsonObject.opt(key)));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if (jsonObject.opt(key) instanceof JSONArray) {
                try {
                    JSONArray jsonArray = (JSONArray)jsonObject.opt(key);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        if (!(jsonArray.opt(i) instanceof JSONObject)) continue;
                        jsonArray.put(i, (Object)JsonUtils.sortAlphabetically((JSONObject)jsonArray.opt(i)));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            jsonKeys.add(key);
        }
        Collections.sort(jsonKeys);
        JSONObject sortedJsonObject = new JSONObject();
        for (String key : jsonKeys) {
            try {
                sortedJsonObject.put(key, jsonObject.opt(key));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sortedJsonObject;
    }
}

