/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.sharedpreferencesviewer;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.sharedpreferencesviewer.adapters.SharedPreferencesViewerListAdapter;
import com.jantursky.debugger.components.sharedpreferencesviewer.comparators.SharedPreferencesListComparator;
import com.jantursky.debugger.components.sharedpreferencesviewer.interfaces.SharedPreferencesViewerListItemListener;
import com.jantursky.debugger.components.sharedpreferencesviewer.models.SharedPreferencesListModel;
import com.jantursky.debugger.interfaces.ComponentListener;
import com.jantursky.debugger.utils.FileUtils;
import com.jantursky.debugger.utils.RecyclerViewUtils;
import com.jantursky.debugger.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class SharedPreferencesView
extends FrameLayout
implements View.OnClickListener,
SharedPreferencesViewerListItemListener {
    private static final String TAG = SharedPreferencesView.class.getSimpleName();
    private View listLayout;
    private View dataLayout;
    private EditText inputEditText;
    private TextView txtCancel;
    private TextView txtEdit;
    private TextView txtDelete;
    private TextView txtClose;
    private int screenType = 0;
    private SharedPreferencesViewerListAdapter sharedPreferencesViewerListAdapter;
    private RecyclerView recyclerViewList;
    private File selectedFile;
    private SharedPreferencesListComparator comparator = new SharedPreferencesListComparator();
    private ComponentListener componentListener;

    public SharedPreferencesView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public SharedPreferencesView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SharedPreferencesView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public SharedPreferencesView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_shared_preferences_viewer, (ViewGroup)this, true);
        this.listLayout = view.findViewById(R.id.list_layout);
        this.dataLayout = view.findViewById(R.id.data_layout);
        this.recyclerViewList = (RecyclerView)view.findViewById(R.id.list_recycler_view);
        this.inputEditText = (EditText)view.findViewById(R.id.input_edittext);
        this.txtCancel = (TextView)view.findViewById(R.id.cancel_textview);
        this.txtClose = (TextView)view.findViewById(R.id.close_textview);
        this.txtDelete = (TextView)view.findViewById(R.id.delete_textview);
        this.txtEdit = (TextView)view.findViewById(R.id.edit_textview);
        this.setTablesList();
        this.displayList();
        this.setListeners();
    }

    public void setComponentListener(ComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    private void setTablesList() {
        this.sharedPreferencesViewerListAdapter = new SharedPreferencesViewerListAdapter();
        this.recyclerViewList.addItemDecoration((RecyclerView.ItemDecoration)RecyclerViewUtils.getVerticalItemDecoration(this.getContext()));
        this.recyclerViewList.setAdapter((RecyclerView.Adapter)this.sharedPreferencesViewerListAdapter);
        ((SimpleItemAnimator)this.recyclerViewList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.sharedPreferencesViewerListAdapter.setOnItemClickListener(this);
    }

    private void displayList() {
        this.screenType = 0;
        this.applyView();
        this.sharedPreferencesViewerListAdapter.setData(this.getDbFiles());
    }

    private void displayFile(File file) {
        this.screenType = 1;
        this.selectedFile = file;
        this.applyView();
        this.displayData();
    }

    private void displayData() {
        String fileContent = FileUtils.readFile(this.selectedFile);
        this.inputEditText.setEnabled(false);
        this.inputEditText.setText((CharSequence)fileContent);
        this.applyEditable();
    }

    private void applyEditable() {
        if (this.inputEditText.isEnabled()) {
            this.txtEdit.setText(R.string.action_save);
        } else {
            this.txtEdit.setText(R.string.action_edit);
        }
    }

    private ArrayList<SharedPreferencesListModel> getDbFiles() {
        File root = new File("/data/data/" + this.getContext().getPackageName() + "/shared_prefs");
        ArrayList<SharedPreferencesListModel> files = new ArrayList<SharedPreferencesListModel>();
        if (root.isDirectory()) {
            File[] list;
            for (File file : list = root.listFiles()) {
                files.add(new SharedPreferencesListModel(file));
            }
        }
        Collections.sort(files, this.comparator);
        return files;
    }

    private void applyView() {
        if (this.screenType == 0) {
            this.listLayout.setVisibility(0);
            this.dataLayout.setVisibility(8);
            this.txtCancel.setVisibility(0);
        } else if (this.screenType == 1) {
            this.listLayout.setVisibility(8);
            this.dataLayout.setVisibility(0);
            this.txtCancel.setVisibility(8);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setListeners() {
        this.txtCancel.setOnClickListener((View.OnClickListener)this);
        this.txtEdit.setOnClickListener((View.OnClickListener)this);
        this.txtDelete.setOnClickListener((View.OnClickListener)this);
        this.txtClose.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.cancel_textview) {
            if (this.componentListener != null) {
                this.componentListener.closeComponent();
            }
        } else if (viewId == R.id.edit_textview) {
            if (this.inputEditText.isEnabled()) {
                this.saveFile(this.selectedFile);
            } else {
                this.inputEditText.setEnabled(true);
            }
            this.applyEditable();
        } else if (viewId == R.id.delete_textview) {
            this.yesNoDialog("Delete the file?", "Yes", "No", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int which) {
                    if (which == -1) {
                        SharedPreferencesView.this.deleteFile(SharedPreferencesView.this.selectedFile);
                    } else if (which == -2) {
                        // empty if block
                    }
                }
            });
        } else if (viewId == R.id.close_textview) {
            this.canGoBack();
        }
    }

    private void saveFile(File file) {
        try {
            FileWriter out = new FileWriter(file, false);
            out.write(this.inputEditText.getText().toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.displayData();
    }

    private void yesNoDialog(String message, String yes, String no, DialogInterface.OnClickListener dialogClickListener) {
        this.yesNoDialog(message, yes, no, null, dialogClickListener);
    }

    private void yesNoDialog(String message, String yes, String no, String neutral, DialogInterface.OnClickListener dialogClickListener) {
        if (StringUtils.isEmpty(message)) {
            message = "";
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)message);
        if (!StringUtils.isEmpty(yes)) {
            builder.setPositiveButton((CharSequence)yes, dialogClickListener);
        }
        if (!StringUtils.isEmpty(no)) {
            builder.setNegativeButton((CharSequence)no, dialogClickListener);
        }
        if (!StringUtils.isEmpty(neutral)) {
            builder.setNeutralButton((CharSequence)neutral, dialogClickListener);
        }
        builder.show();
    }

    public void deleteFile(File file) {
        if (file.canExecute()) {
            file.delete();
        }
        this.displayList();
    }

    public boolean canGoBack() {
        if (this.screenType == 1) {
            this.displayList();
            return false;
        }
        if (this.screenType == 0) {
            return true;
        }
        return true;
    }

    @Override
    public void onFileClick(File file) {
        this.displayFile(file);
    }
}

