/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.restclient.RestClientComponent;
import com.jantursky.debugger.utils.StringUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ApiCallModel
implements Parcelable {
    public int type;
    private int uniqueId = -1;
    public String url;
    public LinkedHashMap<String, String> headers;
    public String body;
    public int connectionTimeout;
    public int readTimeout;
    public int called = 0;
    public long startTime = -1L;
    public long endTime = -1L;
    public long responseLength = -1L;
    public boolean isRunning;
    public int responseCode = -1;
    public String responseData;
    public String responseError;
    public static final Parcelable.Creator<ApiCallModel> CREATOR = new Parcelable.Creator<ApiCallModel>(){

        public ApiCallModel createFromParcel(Parcel in) {
            return new ApiCallModel(in);
        }

        public ApiCallModel[] newArray(int size) {
            return new ApiCallModel[size];
        }
    };

    public ApiCallModel() {
    }

    public int getId() {
        if (this.uniqueId == -1) {
            this.uniqueId = RestClientComponent.counter.incrementAndGet();
        }
        return this.uniqueId;
    }

    public int getTypeAsString() {
        if (this.isGetType()) {
            return R.string.rest_type_get;
        }
        if (this.isPostType()) {
            return R.string.rest_type_post;
        }
        if (this.isPutType()) {
            return R.string.rest_type_put;
        }
        if (this.isDeleteType()) {
            return R.string.rest_type_delete;
        }
        return 0;
    }

    public int getBgForType() {
        if (this.isGetType()) {
            return R.drawable.rest_get_drawable;
        }
        if (this.isPostType()) {
            return R.drawable.rest_post_drawable;
        }
        if (this.isPutType()) {
            return R.drawable.rest_put_drawable;
        }
        if (this.isDeleteType()) {
            return R.drawable.rest_delete_drawable;
        }
        return 0;
    }

    public void startApiCall() {
        ++this.called;
        this.isRunning = true;
        this.responseLength = -1L;
        this.responseCode = -1;
        this.startTime = -1L;
        this.endTime = -1L;
        this.responseData = null;
        this.responseError = null;
    }

    public boolean hasResponseCode() {
        return this.responseCode != -1;
    }

    public boolean isPostType() {
        return this.type == 1;
    }

    public boolean isGetType() {
        return this.type == 0;
    }

    public boolean isPutType() {
        return this.type == 2;
    }

    public boolean isDeleteType() {
        return this.type == 3;
    }

    public boolean hasInput() {
        return this.body != null && this.body.length() > 0;
    }

    public void stopApiCall() {
        this.isRunning = false;
        this.responseCode = -1;
        this.responseLength = -1L;
        this.startTime = -1L;
        this.endTime = -1L;
        this.responseData = null;
        this.responseError = null;
    }

    protected ApiCallModel(Parcel in) {
        this.type = in.readInt();
        this.uniqueId = in.readInt();
        this.url = in.readString();
        this.headers = (LinkedHashMap)in.readValue(HashMap.class.getClassLoader());
        this.body = in.readString();
        this.connectionTimeout = in.readInt();
        this.readTimeout = in.readInt();
        this.called = in.readInt();
        this.isRunning = in.readByte() != 0;
        this.responseCode = in.readInt();
        this.responseData = in.readString();
        this.responseError = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeInt(this.uniqueId);
        dest.writeString(this.url);
        dest.writeValue(this.headers);
        dest.writeString(this.body);
        dest.writeInt(this.connectionTimeout);
        dest.writeInt(this.readTimeout);
        dest.writeInt(this.called);
        dest.writeByte((byte)(this.isRunning ? 1 : 0));
        dest.writeInt(this.responseCode);
        dest.writeString(this.responseData);
        dest.writeString(this.responseError);
    }

    public String getHeadersAsString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(entry.getKey());
            builder.append(" - ");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    public boolean hasResponseLength() {
        return this.responseLength >= 0L;
    }

    public boolean hasResponseOrErrorData() {
        return this.hasResponseData() || this.hasErrorResponseData();
    }

    public boolean hasResponseData() {
        return !StringUtils.isEmpty(this.responseData);
    }

    public boolean hasErrorResponseData() {
        return !StringUtils.isEmpty(this.responseError);
    }

    public boolean hasEndTime() {
        return this.startTime > 0L && this.endTime > 0L;
    }

    public String getResponseOrErrorData() {
        if (this.hasResponseData()) {
            return this.responseData;
        }
        return this.responseError;
    }
}

