/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.restclient.interfaces.RestClientListItemListener;
import com.jantursky.debugger.components.restclient.models.ApiCallModel;
import com.jantursky.debugger.components.restclient.models.ApiGeneralModel;
import com.jantursky.debugger.utils.AnnotationUtils;
import com.jantursky.debugger.utils.SizeUtils;
import com.jantursky.debugger.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Map;

public class RestClientListAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private final ArrayList<ApiCallModel> array;
    private final Context context;
    private RestClientListItemListener listener;
    private ApiGeneralModel apiCallGeneralModel;

    public RestClientListAdapter(Context context) {
        this.context = context;
        this.array = new ArrayList();
        this.setHasStableIds(true);
    }

    public long getItemId(int position) {
        return this.array.get(position).getId();
    }

    public void setData(ApiGeneralModel apiCallGeneralModel, ArrayList<ApiCallModel> data) {
        this.apiCallGeneralModel = apiCallGeneralModel;
        if (data != null && !data.isEmpty()) {
            this.array.clear();
            this.array.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void updateApiGeneralMode(ApiGeneralModel apiCallGeneralModel) {
        this.apiCallGeneralModel = apiCallGeneralModel;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(RestClientListItemListener listener) {
        this.listener = listener;
    }

    public void cancelApiCall(ApiCallModel model) {
        if (this.hasData()) {
            for (int i = 0; i < this.array.size(); ++i) {
                ApiCallModel apiCallModel = this.array.get(i);
                if (model.getId() != apiCallModel.getId()) continue;
                this.array.get(i).stopApiCall();
                this.notifyItemChanged(i);
                break;
            }
        }
    }

    public void runApiCall(ApiCallModel model) {
        if (this.hasData()) {
            for (int i = 0; i < this.array.size(); ++i) {
                ApiCallModel apiCallModel = this.array.get(i);
                if (model.getId() != apiCallModel.getId()) continue;
                this.array.get(i).startApiCall();
                this.notifyItemChanged(i);
                break;
            }
        }
    }

    public void updateApiCallResult(ApiCallModel model) {
        if (this.hasData()) {
            for (int i = 0; i < this.array.size(); ++i) {
                ApiCallModel apiCallModel = this.array.get(i);
                if (model.getId() != apiCallModel.getId()) continue;
                this.array.set(i, model);
                this.notifyItemChanged(i);
                break;
            }
        }
    }

    private boolean hasData() {
        return this.getItemCount() > 0;
    }

    public ArrayList<ApiCallModel> getData() {
        return this.array;
    }

    public int getItemCount() {
        return this.array.size();
    }

    @NonNull
    public ItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_rest_client_list, viewGroup, false);
        return new ItemHolder(view);
    }

    public void onBindViewHolder(@NonNull ItemHolder holder, int position) {
        ApiCallModel model = this.array.get(position);
        holder.txtUrl.setText((CharSequence)model.url);
        holder.txtType.setText(model.getTypeAsString());
        holder.txtType.setBackgroundResource(model.getBgForType());
        if (model.isRunning) {
            holder.progressBar.setVisibility(0);
            holder.txtCheck.setVisibility(8);
        } else if (model.hasResponseCode()) {
            holder.progressBar.setVisibility(8);
            holder.txtCheck.setVisibility(0);
        } else {
            holder.progressBar.setVisibility(8);
            holder.txtCheck.setVisibility(8);
        }
        if (model.isRunning) {
            holder.txtRunCall.setBackgroundResource(R.drawable.btn_red_drawable);
            holder.txtRunCall.setText(R.string.action_stop_api_call);
        } else {
            holder.txtRunCall.setBackgroundResource(R.drawable.btn_yellow_drawable);
            holder.txtRunCall.setText(R.string.action_run_api_call);
        }
        if (model.hasResponseCode()) {
            holder.txtResponseCode.setVisibility(0);
            int responseTextId = this.context.getResources().getIdentifier("response_code_" + model.responseCode, "string", this.context.getPackageName());
            String responseText = "";
            if (responseTextId != 0) {
                responseText = this.context.getString(responseTextId);
            }
            holder.txtResponseCode.setText((CharSequence)this.context.getString(R.string.response_code, new Object[]{model.responseCode, responseText}));
            holder.txtResponseCode.setTextColor(ContextCompat.getColor((Context)this.context, (int)AnnotationUtils.getTextColorFromResponseCode(model.responseCode)));
        } else {
            holder.txtResponseCode.setVisibility(8);
        }
        if (model.hasResponseLength()) {
            holder.txtResponseLength.setVisibility(0);
            holder.txtResponseLength.setText((CharSequence)this.context.getString(R.string.response_length, new Object[]{SizeUtils.getDataSize(model.responseLength)}));
        } else {
            holder.txtResponseLength.setVisibility(8);
        }
        if (model.hasEndTime()) {
            holder.txtResponseTime.setVisibility(0);
            holder.txtResponseTime.setText((CharSequence)this.context.getString(R.string.response_time, new Object[]{TimeUtils.getLength(model.endTime - model.startTime)}));
        } else {
            holder.txtResponseTime.setVisibility(8);
        }
        if (this.hasHeaders(model)) {
            holder.txtHeaders.setVisibility(0);
            holder.txtHeaders.setText((CharSequence)this.getHeadersAsString(model));
        } else {
            holder.txtHeaders.setVisibility(8);
        }
        if (model.hasResponseOrErrorData()) {
            holder.ltResponseOutput.setVisibility(0);
        } else {
            holder.ltResponseOutput.setVisibility(8);
        }
    }

    private String getHeadersAsString(ApiCallModel model) {
        StringBuilder builder = new StringBuilder();
        if (this.apiCallGeneralModel != null && this.apiCallGeneralModel.hasHeaders()) {
            for (Map.Entry<String, String> entry : this.apiCallGeneralModel.headers.entrySet()) {
                if (builder.length() > 0) {
                    builder.append("\r\n");
                }
                builder.append(entry.getKey());
                builder.append(" - ");
                builder.append(entry.getValue());
            }
        }
        if (model.hasHeaders()) {
            for (Map.Entry<String, String> entry : model.headers.entrySet()) {
                if (builder.length() > 0) {
                    builder.append("\r\n");
                }
                builder.append(entry.getKey());
                builder.append(" - ");
                builder.append(entry.getValue());
            }
        }
        return builder.toString();
    }

    private boolean hasHeaders(ApiCallModel model) {
        return model.hasHeaders() || this.apiCallGeneralModel != null && this.apiCallGeneralModel.hasHeaders();
    }

    public class ItemHolder
    extends RecyclerView.ViewHolder {
        protected final View ltRoot;
        protected final View ltResponseOutput;
        protected final TextView txtUrl;
        protected final TextView txtType;
        protected final TextView txtCheck;
        protected final TextView txtRunCall;
        protected final TextView txtResponseCode;
        protected final TextView txtHeaders;
        protected final TextView txtResponseLength;
        protected final TextView txtResponseTime;
        protected final ProgressBar progressBar;

        public ItemHolder(View view) {
            super(view);
            this.ltRoot = view.findViewById(R.id.root_layout);
            this.ltResponseOutput = view.findViewById(R.id.response_output_layout);
            this.txtUrl = (TextView)view.findViewById(R.id.url_textview);
            this.txtType = (TextView)view.findViewById(R.id.type_textview);
            this.txtCheck = (TextView)view.findViewById(R.id.check_textview);
            this.txtRunCall = (TextView)view.findViewById(R.id.run_call_textview);
            this.txtResponseCode = (TextView)view.findViewById(R.id.response_code_textview);
            this.txtResponseLength = (TextView)view.findViewById(R.id.response_length_textview);
            this.txtResponseTime = (TextView)view.findViewById(R.id.response_time_textview);
            this.txtHeaders = (TextView)view.findViewById(R.id.response_headers_textview);
            this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
            this.txtRunCall.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ApiCallModel model = (ApiCallModel)RestClientListAdapter.this.array.get(ItemHolder.this.getAdapterPosition());
                    if (RestClientListAdapter.this.listener != null) {
                        if (model.isRunning) {
                            RestClientListAdapter.this.listener.stopCall(model);
                        } else {
                            RestClientListAdapter.this.listener.runCall(model);
                        }
                    }
                }
            });
            this.ltResponseOutput.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ApiCallModel model = (ApiCallModel)RestClientListAdapter.this.array.get(ItemHolder.this.getAdapterPosition());
                    if (RestClientListAdapter.this.listener != null) {
                        RestClientListAdapter.this.listener.displayOutputDetail(model);
                    }
                }
            });
            this.txtHeaders.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ApiCallModel model = (ApiCallModel)RestClientListAdapter.this.array.get(ItemHolder.this.getAdapterPosition());
                    if (RestClientListAdapter.this.listener != null) {
                        RestClientListAdapter.this.listener.editHeaders(model);
                    }
                }
            });
        }
    }
}

