/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.dbviewer.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.dbviewer.listeners.DbViewerListItemListener;
import com.jantursky.debugger.components.dbviewer.models.DbViewerModel;
import java.io.File;
import java.util.ArrayList;

public class DbViewerListAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private final ArrayList<DbViewerModel> array = new ArrayList();
    private DbViewerListItemListener listener;

    public void setDatabases(ArrayList<File> databases) {
        if (databases != null && !databases.isEmpty()) {
            this.array.clear();
            for (File database : databases) {
                this.array.add(new DbViewerModel(database));
            }
        }
        this.notifyDataSetChanged();
    }

    public void setTables(ArrayList<String> tables) {
        if (tables != null && !tables.isEmpty()) {
            this.array.clear();
            this.array.add(new DbViewerModel(true));
            for (String table : tables) {
                this.array.add(new DbViewerModel(table));
            }
        }
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(DbViewerListItemListener listener) {
        this.listener = listener;
    }

    public int getItemCount() {
        return null != this.array ? this.array.size() : 0;
    }

    @NonNull
    public ItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_db_viewer_tables_list, viewGroup, false);
        return new ItemHolder(view);
    }

    public void onBindViewHolder(final @NonNull ItemHolder holder, int position) {
        DbViewerModel model = this.array.get(position);
        if (model.isJumpToRootType()) {
            holder.txtName.setText((CharSequence)"...");
        } else if (model.isTableType()) {
            holder.txtName.setText((CharSequence)model.getTableName());
        } else if (model.isColumnType()) {
            holder.txtName.setText((CharSequence)model.getColumnName());
        }
        holder.ltRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int pos = holder.getAdapterPosition();
                if (pos != -1 && DbViewerListAdapter.this.listener != null) {
                    DbViewerModel model = (DbViewerModel)DbViewerListAdapter.this.array.get(pos);
                    if (model.isJumpToRootType()) {
                        DbViewerListAdapter.this.listener.goBack();
                    } else if (model.isTableType()) {
                        DbViewerListAdapter.this.listener.onDatabaseClick(model.table);
                    } else if (model.isColumnType()) {
                        DbViewerListAdapter.this.listener.onTableClick(model.column);
                    }
                }
            }
        });
    }

    public class ItemHolder
    extends RecyclerView.ViewHolder {
        protected final View ltRoot;
        protected final TextView txtName;

        public ItemHolder(View view) {
            super(view);
            this.ltRoot = view.findViewById(R.id.ltRoot);
            this.txtName = (TextView)view.findViewById(R.id.name_textview);
        }
    }
}

