/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.DebuggerComponent;
import com.jantursky.debugger.listeners.DebuggerComponentItemListener;
import com.jantursky.debugger.utils.AnnotationUtils;
import java.util.ArrayList;

public class DebuggerComponentAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private ArrayList<DebuggerComponent> array;
    private DebuggerComponentItemListener listener;

    public DebuggerComponentAdapter(ArrayList<DebuggerComponent> data) {
        this.array = data;
        this.setHasStableIds(true);
    }

    public long getItemId(int position) {
        return this.getItem((int)position).componentType;
    }

    public void setOnItemClickListener(DebuggerComponentItemListener listener) {
        this.listener = listener;
    }

    public DebuggerComponent getItem(int pos) {
        return this.array.get(pos);
    }

    public int getItemCount() {
        return null != this.array ? this.array.size() : 0;
    }

    @NonNull
    public ItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_debugger_component_row, viewGroup, false);
        return new ItemHolder(view, viewType);
    }

    public void onBindViewHolder(final @NonNull ItemHolder holder, int position) {
        DebuggerComponent model = this.getItem(position);
        holder.txtName.setText(AnnotationUtils.getTextIdForComponentType(model.componentType));
        holder.ltRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int pos = holder.getAdapterPosition();
                if (pos != -1 && DebuggerComponentAdapter.this.listener != null) {
                    DebuggerComponentAdapter.this.listener.onItemSelect(DebuggerComponentAdapter.this.getItem(pos));
                }
            }
        });
    }

    public class ItemHolder
    extends RecyclerView.ViewHolder {
        protected ViewGroup ltRoot;
        protected TextView txtName;

        public ItemHolder(View view, int viewType) {
            super(view);
            this.ltRoot = (ViewGroup)view.findViewById(R.id.root_layout);
            this.txtName = (TextView)view.findViewById(R.id.name_textview);
        }
    }
}

