/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.sharedpreferencesviewer.comparators;

import com.jantursky.debugger.components.sharedpreferencesviewer.models.SharedPreferencesListModel;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class SharedPreferencesListComparator
implements Comparator<SharedPreferencesListModel> {
    private final Collator collator = Collator.getInstance(Locale.getDefault());

    public SharedPreferencesListComparator() {
        this.collator.setStrength(1);
    }

    @Override
    public int compare(SharedPreferencesListModel m1, SharedPreferencesListModel m2) {
        return this.compareTexts(m1.file.getName(), m2.file.getName());
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    public int compareTexts(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }
}

