/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.sharedpreferencesviewer.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.sharedpreferencesviewer.interfaces.SharedPreferencesViewerListItemListener;
import com.jantursky.debugger.components.sharedpreferencesviewer.models.SharedPreferencesListModel;
import java.util.ArrayList;

public class SharedPreferencesViewerListAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private final ArrayList<SharedPreferencesListModel> array = new ArrayList();
    private SharedPreferencesViewerListItemListener listener;

    public void setData(ArrayList<SharedPreferencesListModel> data) {
        if (data != null && !data.isEmpty()) {
            this.array.clear();
            this.array.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(SharedPreferencesViewerListItemListener listener) {
        this.listener = listener;
    }

    public int getItemCount() {
        return null != this.array ? this.array.size() : 0;
    }

    @NonNull
    public ItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_shared_preferences_viewer_list, viewGroup, false);
        return new ItemHolder(view);
    }

    public void onBindViewHolder(final @NonNull ItemHolder holder, int position) {
        SharedPreferencesListModel model = this.array.get(position);
        holder.txtName.setText((CharSequence)model.file.getName());
        holder.ltRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int pos = holder.getAdapterPosition();
                if (pos != -1 && SharedPreferencesViewerListAdapter.this.listener != null) {
                    SharedPreferencesListModel model = (SharedPreferencesListModel)SharedPreferencesViewerListAdapter.this.array.get(pos);
                    SharedPreferencesViewerListAdapter.this.listener.onFileClick(model.file);
                }
            }
        });
    }

    public class ItemHolder
    extends RecyclerView.ViewHolder {
        protected final View ltRoot;
        protected final TextView txtName;

        public ItemHolder(View view) {
            super(view);
            this.ltRoot = view.findViewById(R.id.ltRoot);
            this.txtName = (TextView)view.findViewById(R.id.name_textview);
        }
    }
}

