/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient.models;

import com.jantursky.debugger.components.restclient.RestClientComponent;
import java.util.HashMap;

public class ApiCallModel {
    public int type;
    private int uniqueId = -1;
    public String url;
    public HashMap<String, String> headers;
    public String body;
    public int connectionTimeout;
    public int readTimeout;
    public int called = 0;
    public boolean isRunning;
    public int responseCode = -1;
    public String responseData;
    public String responseError;

    public int getId() {
        if (this.uniqueId == -1) {
            this.uniqueId = RestClientComponent.counter.incrementAndGet();
        }
        return this.uniqueId;
    }

    public String getTypeAsString() {
        if (this.isGetType()) {
            return "GET";
        }
        if (this.isPostType()) {
            return "POST";
        }
        if (this.isPutType()) {
            return "PUT";
        }
        if (this.isDeleteType()) {
            return "DELETE";
        }
        return "";
    }

    public void startApiCall() {
        ++this.called;
        this.isRunning = true;
        this.responseCode = -1;
        this.responseData = null;
        this.responseError = null;
    }

    public boolean hasResponseCode() {
        return this.responseCode != -1;
    }

    public boolean isPostType() {
        return this.type == 1;
    }

    public boolean isGetType() {
        return this.type == 0;
    }

    public boolean isPutType() {
        return this.type == 2;
    }

    public boolean isDeleteType() {
        return this.type == 3;
    }

    public boolean hasInput() {
        return this.body != null && this.body.length() > 0;
    }

    public void stopApiCall() {
        this.isRunning = false;
        this.responseCode = -1;
        this.responseData = null;
        this.responseError = null;
    }
}

