/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.restclient.interfaces.RestClientListItemListener;
import com.jantursky.debugger.components.restclient.models.ApiCallModel;
import java.util.ArrayList;

public class RestClientListAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private final ArrayList<ApiCallModel> array;
    private final Context context;
    private RestClientListItemListener listener;

    public RestClientListAdapter(Context context) {
        this.context = context;
        this.array = new ArrayList();
        this.setHasStableIds(true);
    }

    public long getItemId(int position) {
        return this.array.get(position).getId();
    }

    public void setData(ArrayList<ApiCallModel> data) {
        if (data != null && !data.isEmpty()) {
            this.array.clear();
            this.array.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(RestClientListItemListener listener) {
        this.listener = listener;
    }

    public void cancelApiCall(ApiCallModel model) {
        if (this.hasData()) {
            for (int i = 0; i < this.array.size(); ++i) {
                ApiCallModel apiCallModel = this.array.get(i);
                if (model.getId() != apiCallModel.getId()) continue;
                this.array.get(i).stopApiCall();
                this.notifyItemChanged(i);
                break;
            }
        }
    }

    public void runApiCall(ApiCallModel model) {
        if (this.hasData()) {
            for (int i = 0; i < this.array.size(); ++i) {
                ApiCallModel apiCallModel = this.array.get(i);
                if (model.getId() != apiCallModel.getId()) continue;
                this.array.get(i).startApiCall();
                this.notifyItemChanged(i);
                break;
            }
        }
    }

    public void updateApiCallResult(ApiCallModel model) {
        if (this.hasData()) {
            for (int i = 0; i < this.array.size(); ++i) {
                ApiCallModel apiCallModel = this.array.get(i);
                if (model.getId() != apiCallModel.getId()) continue;
                this.array.set(i, model);
                this.notifyItemChanged(i);
                break;
            }
        }
    }

    private boolean hasData() {
        return this.getItemCount() > 0;
    }

    public ArrayList<ApiCallModel> getData() {
        return this.array;
    }

    public int getItemCount() {
        return this.array.size();
    }

    @NonNull
    public ItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_rest_client_list, viewGroup, false);
        return new ItemHolder(view);
    }

    public void onBindViewHolder(@NonNull ItemHolder holder, int position) {
        ApiCallModel model = this.array.get(position);
        holder.txtUrl.setText((CharSequence)model.url);
        holder.txtType.setText((CharSequence)model.getTypeAsString());
        holder.progressBar.setVisibility(model.isRunning ? 0 : 8);
        if (model.isRunning) {
            holder.txtRunCall.setBackgroundResource(R.drawable.btn_red_drawable);
            holder.txtRunCall.setText(R.string.action_stop_api_call);
        } else {
            holder.txtRunCall.setBackgroundResource(R.drawable.btn_yellow_drawable);
            holder.txtRunCall.setText(R.string.action_run_api_call);
        }
        if (model.hasResponseCode()) {
            holder.txtResponseCode.setVisibility(0);
            holder.txtResponseCode.setText((CharSequence)this.context.getString(R.string.response_code, new Object[]{model.responseCode}));
        } else {
            holder.txtResponseCode.setVisibility(8);
        }
    }

    public class ItemHolder
    extends RecyclerView.ViewHolder {
        protected final View ltRoot;
        protected final TextView txtUrl;
        protected final TextView txtType;
        protected final TextView txtRunCall;
        protected final TextView txtResponseCode;
        protected final ProgressBar progressBar;

        public ItemHolder(View view) {
            super(view);
            this.ltRoot = view.findViewById(R.id.root_layout);
            this.txtUrl = (TextView)view.findViewById(R.id.url_textview);
            this.txtType = (TextView)view.findViewById(R.id.type_textview);
            this.txtRunCall = (TextView)view.findViewById(R.id.run_call_textview);
            this.txtResponseCode = (TextView)view.findViewById(R.id.response_code_textview);
            this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
            this.txtRunCall.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ApiCallModel model = (ApiCallModel)RestClientListAdapter.this.array.get(ItemHolder.this.getAdapterPosition());
                    if (RestClientListAdapter.this.listener != null) {
                        if (model.isRunning) {
                            RestClientListAdapter.this.listener.stopCall(model);
                        } else {
                            RestClientListAdapter.this.listener.runCall(model);
                        }
                    }
                }
            });
        }
    }
}

