/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.restclient.adapters.RestClientListAdapter;
import com.jantursky.debugger.components.restclient.interfaces.RestClientListItemListener;
import com.jantursky.debugger.components.restclient.interfaces.RestClientResultListener;
import com.jantursky.debugger.components.restclient.models.ApiCallModel;
import com.jantursky.debugger.components.restclient.tasks.ApiCallTask;
import com.jantursky.debugger.interfaces.ComponentListener;
import com.jantursky.debugger.utils.RecyclerViewUtils;
import java.util.ArrayList;

public class RestClientView
extends FrameLayout
implements View.OnClickListener,
RestClientListItemListener,
RestClientResultListener {
    private static final String TAG = RestClientView.class.getSimpleName();
    private TextView txtRunAll;
    private TextView txtStopAll;
    private TextView txtClose;
    private RestClientListAdapter restClientListAdapter;
    private RecyclerView recyclerViewList;
    private ComponentListener componentListener;
    private SparseArray<AsyncTask> tasks = new SparseArray();

    public RestClientView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public RestClientView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RestClientView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public RestClientView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_rest_client, (ViewGroup)this, true);
        this.recyclerViewList = (RecyclerView)view.findViewById(R.id.list_recycler_view);
        this.txtClose = (TextView)view.findViewById(R.id.close_textview);
        this.txtRunAll = (TextView)view.findViewById(R.id.run_all_textview);
        this.txtStopAll = (TextView)view.findViewById(R.id.stop_all_textview);
        this.setList();
        this.setListeners();
    }

    public void setComponentListener(ComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    private void setList() {
        this.restClientListAdapter = new RestClientListAdapter(this.getContext());
        this.recyclerViewList.addItemDecoration((RecyclerView.ItemDecoration)RecyclerViewUtils.getVerticalItemDecoration(this.getContext()));
        this.recyclerViewList.setAdapter((RecyclerView.Adapter)this.restClientListAdapter);
        ((SimpleItemAnimator)this.recyclerViewList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.restClientListAdapter.setOnItemClickListener(this);
    }

    private void setListeners() {
        this.txtRunAll.setOnClickListener((View.OnClickListener)this);
        this.txtStopAll.setOnClickListener((View.OnClickListener)this);
        this.txtClose.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.close_textview) {
            this.stopAllCalls();
            if (this.componentListener != null) {
                this.componentListener.closeComponent();
            }
        } else if (viewId == R.id.run_all_textview) {
            if (RestClientView.isNetworkAvailable(this.getContext())) {
                this.runAllCalls();
            } else {
                Toast.makeText((Context)this.getContext(), (int)R.string.toast_no_network, (int)0).show();
            }
        } else if (viewId == R.id.stop_all_textview) {
            this.stopAllCalls();
        }
    }

    private void runAllCalls() {
        ArrayList<ApiCallModel> data = this.restClientListAdapter.getData();
        for (ApiCallModel model : data) {
            this.runCall(model);
        }
    }

    private void stopAllCalls() {
        ArrayList<ApiCallModel> data = this.restClientListAdapter.getData();
        for (ApiCallModel model : data) {
            this.stopCall(model);
        }
    }

    @Override
    public void onRowClick(ApiCallModel model) {
    }

    @Override
    public void runCall(ApiCallModel model) {
        if (RestClientView.isNetworkAvailable(this.getContext())) {
            if (this.isRunning(model)) {
                this.cancel(model);
            }
            this.restClientListAdapter.runApiCall(model);
            this.tasks.put(model.getId(), (Object)new ApiCallTask(model, this).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]));
        } else {
            Toast.makeText((Context)this.getContext(), (int)R.string.toast_no_network, (int)0).show();
        }
    }

    private void cancel(ApiCallModel model) {
        if (this.tasks.get(model.getId()) != null) {
            RestClientView.closeTask((AsyncTask)this.tasks.get(model.getId()));
            this.tasks.remove(model.getId());
            this.restClientListAdapter.cancelApiCall(model);
        }
    }

    private boolean isRunning(ApiCallModel model) {
        return this.tasks.get(model.getId()) != null && RestClientView.isRunningTask((AsyncTask)this.tasks.get(model.getId()));
    }

    @Override
    public void stopCall(ApiCallModel model) {
        this.cancel(model);
    }

    public void setApiCalls(ArrayList<ApiCallModel> apiCalls) {
        this.restClientListAdapter.setData(apiCalls);
    }

    public static void closeTask(AsyncTask ... tasks) {
        for (AsyncTask task : tasks) {
            if (!RestClientView.isRunningTask(task)) continue;
            task.cancel(true);
        }
    }

    public static boolean isRunningTask(AsyncTask task) {
        return task != null && (task.getStatus() == AsyncTask.Status.PENDING || task.getStatus() == AsyncTask.Status.RUNNING);
    }

    @Override
    public void onApiCallResult(ApiCallModel model) {
        this.restClientListAdapter.updateApiCallResult(model);
    }

    @Override
    public void onApiCallCancel(ApiCallModel model) {
        this.restClientListAdapter.updateApiCallResult(model);
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetworkInfo = null;
            if (connectivityManager != null) {
                activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            }
            return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
        }
        catch (Exception e) {
            return false;
        }
    }
}

