/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.dbviewer.models;

import com.jantursky.debugger.components.dbviewer.models.DbViewerDataModel;
import com.jantursky.debugger.utils.JsonUtils;

public class DbViewerRowModel
extends DbViewerDataModel {
    public int type;
    public String typeText;
    public int valueInt;
    public float valueFloat;
    public String valueString;
    public String primaryColumnName;
    public String primaryColumnValue;

    public DbViewerRowModel(int columnPos, int rowType) {
        super(rowType);
        this.columnPos = columnPos;
    }

    public DbViewerRowModel(int columnPos, boolean isHidden, int rowType, String primaryColumnName, String primaryColumnValue) {
        super(rowType);
        this.primaryColumnName = primaryColumnName;
        this.primaryColumnValue = primaryColumnValue;
        this.columnPos = columnPos;
        this.isHidden = isHidden;
    }

    public DbViewerRowModel(int columnPos, String dbKey, String name, String type, int rowType, String primaryColumnName, String primaryColumnValue) {
        super(rowType);
        this.primaryColumnName = primaryColumnName;
        this.primaryColumnValue = primaryColumnValue;
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.valueString = name;
        this.typeText = type;
    }

    public DbViewerRowModel(int columnPos, String dbKey, int type, int rowType, int valueInt, String primaryColumnName, String primaryColumnValue) {
        super(rowType);
        this.primaryColumnName = primaryColumnName;
        this.primaryColumnValue = primaryColumnValue;
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.type = type;
        this.valueInt = valueInt;
    }

    public DbViewerRowModel(int columnPos, String dbKey, int type, int rowType, float valueFloat, String primaryColumnName, String primaryColumnValue) {
        super(rowType);
        this.primaryColumnName = primaryColumnName;
        this.primaryColumnValue = primaryColumnValue;
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.type = type;
        this.valueFloat = valueFloat;
    }

    public DbViewerRowModel(int columnPos, String dbKey, int type, int rowType, String valueString, String primaryColumnName, String primaryColumnValue) {
        super(rowType);
        this.primaryColumnName = primaryColumnName;
        this.primaryColumnValue = primaryColumnValue;
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.type = type;
        this.valueString = valueString;
    }

    public String toString() {
        return "DbViewerRowModel{type=" + this.type + ", typeText='" + this.typeText + '\'' + ", valueInt=" + this.valueInt + ", valueFloat=" + this.valueFloat + ", valueString='" + this.valueString + '\'' + ", primaryColumnName='" + this.primaryColumnName + '\'' + ", primaryColumnValue='" + this.primaryColumnValue + '\'' + ", rowType=" + this.rowType + ", columnPos=" + this.columnPos + ", isHidden=" + this.isHidden + ", dbKey='" + this.dbKey + '\'' + '}';
    }

    @Override
    public String getText() {
        if (this.rowType == 0) {
            return this.valueString;
        }
        if (this.rowType == 2) {
            if (this.type == 3) {
                return this.valueString;
            }
            if (this.type == 1) {
                return String.valueOf(this.valueInt);
            }
            if (this.type == 2) {
                return String.valueOf(this.valueFloat);
            }
            if (this.type == 4) {
                return this.valueString;
            }
            return "";
        }
        return "";
    }

    public String getCleanedText() {
        return this.getCleanedText(false);
    }

    public String getCleanedText(boolean sortAlphabetically) {
        return JsonUtils.getIndentedText(this.getText(), sortAlphabetically);
    }

    @Override
    public String geType() {
        return this.typeText;
    }
}

