/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.dbviewer;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.dbviewer.adapters.DbViewerGridRowAdapter;
import com.jantursky.debugger.components.dbviewer.adapters.DbViewerListAdapter;
import com.jantursky.debugger.components.dbviewer.comparators.DbGridComparator;
import com.jantursky.debugger.components.dbviewer.helpers.DBViewerHelper;
import com.jantursky.debugger.components.dbviewer.listeners.DbViewerGridItemListener;
import com.jantursky.debugger.components.dbviewer.listeners.DbViewerInputListener;
import com.jantursky.debugger.components.dbviewer.listeners.DbViewerListItemListener;
import com.jantursky.debugger.components.dbviewer.models.DbViewerColumnModel;
import com.jantursky.debugger.components.dbviewer.models.DbViewerDataModel;
import com.jantursky.debugger.components.dbviewer.models.DbViewerRecyclerViewModel;
import com.jantursky.debugger.components.dbviewer.models.DbViewerRowModel;
import com.jantursky.debugger.interfaces.ComponentListener;
import com.jantursky.debugger.interfaces.GlobalViewListener;
import com.jantursky.debugger.listeners.RepeatListener;
import com.jantursky.debugger.utils.FormatUtils;
import com.jantursky.debugger.utils.RecyclerViewUtils;
import com.jantursky.debugger.utils.StringUtils;
import com.jantursky.debugger.utils.ViewUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DbGridView
extends FrameLayout
implements View.OnClickListener,
DbViewerListItemListener,
DbViewerGridItemListener {
    private static final String TAG = DbGridView.class.getSimpleName();
    private static final float ALPHA_DISABLED = 0.4f;
    private static final float ALPHA_ENABLED = 1.0f;
    private LinearLayout gridCntLayout;
    private View listLayout;
    private View dataLayout;
    private TextView txtCancel;
    private TextView pageTxt;
    private TextView txtSchema;
    private TextView txtQuery;
    private TextView txtRowCount;
    private TextView pageLeftTxt;
    private TextView pageRightTxt;
    private TextView pageFirstTxt;
    private TextView pageLastTxt;
    private TextView closeTxt;
    private TextView deleteTxt;
    private TextView addTxt;
    private DBViewerHelper dbHelper;
    private int screenType = 1;
    private DbViewerListAdapter dbViewerListAdapter;
    private RecyclerView recyclerViewList;
    private float rowHeight;
    private int count = 0;
    private int currentPage = 1;
    private int totalPage = 1;
    private int maxPerPage = 0;
    private int scrollBy = 0;
    private String selectedTable;
    private ArrayList<DbViewerDataModel> headerRow;
    private ArrayList<DbViewerRecyclerViewModel> recyclerViews;
    private RecyclerView.RecycledViewPool recyclerViewPoolItems;
    final RecyclerView.OnScrollListener listener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            DbGridView.this.scrollBy = DbGridView.this.scrollBy + dx;
            if (DbGridView.this.scrollBy < 0) {
                DbGridView.this.scrollBy = 0;
            }
            DbGridView.this.scrollToX((Integer)recyclerView.getTag(), dx);
        }
    };
    private ArrayList<ArrayList<DbViewerDataModel>> data;
    private DbGridComparator comparator = new DbGridComparator();
    private int lastHeaderPos = -1;
    private ComponentListener componentListener;

    public DbGridView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public DbGridView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DbGridView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public DbGridView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_db_grid, (ViewGroup)this, true);
        this.gridCntLayout = (LinearLayout)view.findViewById(R.id.grid_cnt_layout);
        this.listLayout = view.findViewById(R.id.list_layout);
        this.dataLayout = view.findViewById(R.id.data_layout);
        this.recyclerViewList = (RecyclerView)view.findViewById(R.id.list_recycler_view);
        this.txtCancel = (TextView)view.findViewById(R.id.cancel_textview);
        this.pageTxt = (TextView)view.findViewById(R.id.page_textview);
        this.txtSchema = (TextView)view.findViewById(R.id.schema_textview);
        this.txtQuery = (TextView)view.findViewById(R.id.query_textview);
        this.txtRowCount = (TextView)view.findViewById(R.id.row_count_textview);
        this.pageLeftTxt = (TextView)view.findViewById(R.id.page_left_textview);
        this.pageRightTxt = (TextView)view.findViewById(R.id.page_right_textview);
        this.pageFirstTxt = (TextView)view.findViewById(R.id.page_first_textview);
        this.pageLastTxt = (TextView)view.findViewById(R.id.page_last_textview);
        this.deleteTxt = (TextView)view.findViewById(R.id.delete_textview);
        this.closeTxt = (TextView)view.findViewById(R.id.close_textview);
        this.addTxt = (TextView)view.findViewById(R.id.add_textview);
        this.rowHeight = this.getContext().getResources().getDimension(R.dimen.db_viewer_row_height);
        this.recyclerViewPoolItems = new RecyclerView.RecycledViewPool();
        this.setTablesList();
        ViewUtils.addListener((View)this.gridCntLayout, new GlobalViewListener(){

            @Override
            public void onGlobalLayout(int width, int height) {
                DbGridView.this.maxPerPage = (int)Math.floor((float)height / DbGridView.this.rowHeight);
                DbGridView.this.displayDatabases();
            }
        });
        this.setListeners();
    }

    public void setComponentListener(ComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    private void setTablesList() {
        this.dbViewerListAdapter = new DbViewerListAdapter();
        this.recyclerViewList.addItemDecoration((RecyclerView.ItemDecoration)RecyclerViewUtils.getVerticalItemDecoration(this.getContext()));
        this.recyclerViewList.setAdapter((RecyclerView.Adapter)this.dbViewerListAdapter);
        ((SimpleItemAnimator)this.recyclerViewList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.dbViewerListAdapter.setOnItemClickListener(this);
    }

    private void displayDatabases() {
        this.screenType = 0;
        this.applyView();
        this.dbViewerListAdapter.setDatabases(this.getDbFiles());
    }

    public void displayTables() {
        this.screenType = 1;
        this.applyView();
        this.dbViewerListAdapter.setTables(this.getTables());
    }

    private ArrayList<File> getDbFiles() {
        File root = new File("/data/data/" + this.getContext().getPackageName() + "/databases");
        ArrayList<File> files = new ArrayList<File>();
        if (root.isDirectory()) {
            File[] list;
            for (File file : list = root.listFiles()) {
                String extension = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf("."));
                if (extension.equals(".db-journal")) continue;
                files.add(file);
            }
        }
        return files;
    }

    private ArrayList<String> getTables() {
        return this.dbHelper.getAllTables();
    }

    private void applyView() {
        if (this.screenType == 0 || this.screenType == 1) {
            this.listLayout.setVisibility(0);
            this.dataLayout.setVisibility(8);
            this.txtCancel.setVisibility(0);
        } else if (this.screenType == 2) {
            this.listLayout.setVisibility(8);
            this.dataLayout.setVisibility(0);
            this.txtCancel.setVisibility(8);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setListeners() {
        this.pageTxt.setOnClickListener((View.OnClickListener)this);
        this.txtCancel.setOnClickListener((View.OnClickListener)this);
        this.txtQuery.setOnClickListener((View.OnClickListener)this);
        this.txtSchema.setOnClickListener((View.OnClickListener)this);
        this.closeTxt.setOnClickListener((View.OnClickListener)this);
        this.deleteTxt.setOnClickListener((View.OnClickListener)this);
        this.pageFirstTxt.setOnClickListener((View.OnClickListener)this);
        this.pageLastTxt.setOnClickListener((View.OnClickListener)this);
        this.pageLeftTxt.setOnTouchListener((View.OnTouchListener)new RepeatListener(400L, 30L, true, new View.OnClickListener(){

            public void onClick(View view) {
                int current = DbGridView.this.currentPage - 1;
                DbGridView.this.jumpToPage(current);
            }
        }));
        this.pageRightTxt.setOnTouchListener((View.OnTouchListener)new RepeatListener(400L, 30L, true, new View.OnClickListener(){

            public void onClick(View view) {
                int current = DbGridView.this.currentPage + 1;
                DbGridView.this.jumpToPage(current);
            }
        }));
    }

    private void selectDb(File dbFile) {
        DBViewerHelper.resetInstance();
        this.dbHelper = DBViewerHelper.getInstance(this.getContext(), dbFile);
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.cancel_textview) {
            if (this.componentListener != null) {
                this.componentListener.closeComponent();
            }
        } else if (viewId == R.id.page_textview) {
            this.displayJumpToPageDialog();
        } else if (viewId == R.id.delete_textview) {
            this.yesNoDialog("Delete the table?", "Yes", "No", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int which) {
                    if (which == -1) {
                        DbGridView.this.deleteTable(DbGridView.this.selectedTable);
                    } else if (which == -2) {
                        // empty if block
                    }
                }
            });
        } else if (viewId == R.id.close_textview) {
            this.canGoBack();
        } else if (viewId == R.id.add_textview) {
            this.addRow();
        } else if (viewId == R.id.page_first_textview) {
            this.jumpToFirst();
        } else if (viewId == R.id.page_last_textview) {
            this.jumpToLast();
        } else if (viewId == R.id.schema_textview) {
            this.yesNoDialog(FormatUtils.formatSchema(this.dbHelper.getSchema(this.selectedTable)), "Close", null, null);
        } else if (viewId == R.id.query_textview) {
            this.inputDialog("Create query", "Select * from " + this.selectedTable, "Execute", "Cancel", new DbViewerInputListener(){

                @Override
                public void applyInput(String text) {
                    if (!DbGridView.this.isEmpty(text)) {
                        DbGridView.this.fillData(null, text);
                    }
                }

                @Override
                public void neutral() {
                }
            });
        }
    }

    private void jumpToFirst() {
        int current = 1;
        this.jumpToPage(current);
    }

    private void jumpToLast() {
        int current = this.totalPage;
        this.jumpToPage(current);
    }

    private boolean isEmpty(String text) {
        return StringUtils.isEmpty(text);
    }

    private void inputDialog(String message, String inputText, String yes, String no, DbViewerInputListener listener) {
        this.inputDialog(message, inputText, yes, no, null, listener);
    }

    private void inputDialog(String message, String inputText, String yes, String no, String neutral, final DbViewerInputListener listener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)message);
        final EditText input = new EditText(this.getContext());
        input.setInputType(1);
        input.setText((CharSequence)inputText);
        input.setSingleLine(false);
        input.setImeOptions(0x40000000);
        builder.setView((View)input);
        input.setSelection(input.getText().length());
        if (!this.isEmpty(yes)) {
            builder.setPositiveButton((CharSequence)yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (listener != null) {
                        listener.applyInput(input.getText().toString());
                    }
                }
            });
        }
        if (!this.isEmpty(no)) {
            builder.setNegativeButton((CharSequence)no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
        }
        if (!this.isEmpty(neutral)) {
            builder.setNeutralButton((CharSequence)neutral, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (listener != null) {
                        listener.neutral();
                    }
                }
            });
        }
        builder.show();
    }

    private void yesNoDialog(String message, String yes, String no, DialogInterface.OnClickListener dialogClickListener) {
        this.yesNoDialog(message, yes, no, null, dialogClickListener);
    }

    private void yesNoDialog(String message, String yes, String no, String neutral, DialogInterface.OnClickListener dialogClickListener) {
        if (this.isEmpty(message)) {
            message = "";
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)message);
        if (!this.isEmpty(yes)) {
            builder.setPositiveButton((CharSequence)yes, dialogClickListener);
        }
        if (!this.isEmpty(no)) {
            builder.setNegativeButton((CharSequence)no, dialogClickListener);
        }
        if (!this.isEmpty(neutral)) {
            builder.setNeutralButton((CharSequence)neutral, dialogClickListener);
        }
        builder.show();
    }

    public void deleteTable(String table) {
        this.dbHelper.delete(table, null);
        this.resetDataView();
        this.displayData(table, null);
    }

    private void jumpToPage(int current) {
        if (current >= 1 && current <= this.totalPage) {
            this.currentPage = current;
            this.refreshGridList();
        }
    }

    private void refreshGridList() {
        this.applyRowChanges();
        this.setRowData();
    }

    private void applyRowChanges() {
        this.setBottomPages();
        this.checkPages();
    }

    private void checkPages() {
        if (this.currentPage <= 1) {
            this.pageLeftTxt.setAlpha(0.4f);
            this.pageLeftTxt.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.db_viewer_bottom_bg));
            this.pageFirstTxt.setVisibility(4);
        } else {
            this.pageLeftTxt.setAlpha(1.0f);
            this.pageLeftTxt.setBackgroundResource(R.drawable.db_viewer_icon_selector);
            this.pageFirstTxt.setVisibility(0);
            this.pageRightTxt.setBackgroundResource(R.drawable.db_viewer_icon_selector);
        }
        if (this.currentPage >= this.totalPage) {
            this.pageRightTxt.setAlpha(0.4f);
            this.pageRightTxt.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.db_viewer_bottom_bg));
            this.pageLastTxt.setVisibility(4);
        } else {
            this.pageRightTxt.setAlpha(1.0f);
            this.pageRightTxt.setBackgroundResource(R.drawable.db_viewer_icon_selector);
            this.pageLastTxt.setVisibility(0);
        }
    }

    private void displayJumpToPageDialog() {
    }

    private void addRow() {
    }

    @Override
    public void goBack() {
        this.canGoBack();
    }

    @Override
    public void onDatabaseClick(File databaseFile) {
        this.selectDb(databaseFile);
        this.displayTables();
    }

    @Override
    public void onTableClick(String table) {
        this.resetDataView();
        this.displayData(table, null);
    }

    private void resetDataView() {
        this.scrollBy = 0;
        this.count = 0;
        this.currentPage = 1;
        this.totalPage = 1;
        this.lastHeaderPos = -1;
    }

    private void displayData(String table, String query) {
        this.screenType = 2;
        this.applyView();
        this.fillData(table, query);
    }

    private void firstListFill() {
        this.gridCntLayout.addView(this.addRecyclerRow(this.headerRow.size(), true, 0));
        for (int i = 0; i < this.maxPerPage; ++i) {
            int pos = i + 1;
            this.gridCntLayout.addView(this.addRecyclerRow(this.headerRow.size(), false, pos));
        }
    }

    private void fillData(String table, String query) {
        String[] tableColumns;
        if (!this.isEmpty(table)) {
            this.selectedTable = table;
            this.deleteTxt.setVisibility(0);
            tableColumns = this.dbHelper.getAllColumns(table);
            this.headerRow = this.dbHelper.getColumnsType(table);
            this.count = this.dbHelper.getCountForTable(table);
            this.totalPage = (int)Math.ceil(this.count / (this.maxPerPage - 1));
            if ((this.maxPerPage - 1) * this.totalPage <= this.count) {
                ++this.totalPage;
            }
            this.data = this.dbHelper.getDataForTable(table, tableColumns, this.getPrimaryColumn(this.headerRow));
        } else {
            this.selectedTable = null;
            this.deleteTxt.setVisibility(8);
            tableColumns = this.dbHelper.getCustomColumns(query);
            this.headerRow = this.dbHelper.getColumnsType(query);
            this.count = this.dbHelper.getCountForQuery(query);
            this.totalPage = (int)Math.ceil(this.count / this.maxPerPage);
            if (this.maxPerPage * this.totalPage <= this.count) {
                ++this.totalPage;
            }
            this.data = this.dbHelper.getDataForQuery(query, tableColumns, this.getPrimaryColumn(this.headerRow));
        }
        this.txtRowCount.setText((CharSequence)this.getResources().getQuantityString(R.plurals.data_row_count, this.data.size(), new Object[]{this.data.size()}));
        if (this.recyclerViews == null) {
            this.recyclerViews = new ArrayList();
        } else {
            for (DbViewerRecyclerViewModel recyclerView : this.recyclerViews) {
                recyclerView.recyclerView.removeOnScrollListener(this.listener);
            }
        }
        this.recyclerViews.clear();
        this.gridCntLayout.removeAllViews();
        this.firstListFill();
        this.applyRowChanges();
        this.setRowData();
    }

    private String getPrimaryColumn(ArrayList<DbViewerDataModel> headerRow) {
        if (headerRow != null && !headerRow.isEmpty()) {
            for (DbViewerDataModel dbViewerDataModel : headerRow) {
                if (!((DbViewerColumnModel)dbViewerDataModel).isPrimaryKey) continue;
                return ((DbViewerColumnModel)dbViewerDataModel).columnName;
            }
        }
        return null;
    }

    private void setRowData() {
        if (this.data != null) {
            List<ArrayList<DbViewerDataModel>> dataPerPage = this.getDataForPage(this.currentPage, this.maxPerPage, this.data);
            this.updateGridRow(this.headerRow, this.getColumns(), true, this.recyclerViews.get(0), 0);
            for (int i = 0; i < this.maxPerPage; ++i) {
                int pos = i + 1;
                if (!dataPerPage.isEmpty() && i < dataPerPage.size()) {
                    ArrayList<DbViewerDataModel> arrayList = dataPerPage.get(i);
                    this.updateGridRow(arrayList, this.getColumns(), false, this.recyclerViews.get(pos), pos);
                    continue;
                }
                this.updateGridRow(null, this.getColumns(), false, this.recyclerViews.get(pos), pos);
            }
        }
    }

    private int getColumns() {
        return this.headerRow != null ? this.headerRow.size() : 0;
    }

    private void updateGridRow(ArrayList<DbViewerDataModel> headerRow, int columns, boolean isHeader, DbViewerRecyclerViewModel dbViewerRecyclerViewModel, int pos) {
        dbViewerRecyclerViewModel.adapter.setData(headerRow, columns, isHeader, this.currentPage, this.maxPerPage, pos);
    }

    private View addRecyclerRow(int columns, boolean isHeader, int tagId) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_db_grid_recyclerview, (ViewGroup)this, false);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.list_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        DbViewerGridRowAdapter adapter = new DbViewerGridRowAdapter(this.getContext(), isHeader);
        adapter.setOnItemClickListener(this);
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        ((SimpleItemAnimator)recyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        recyclerView.setTag((Object)tagId);
        recyclerView.addOnScrollListener(this.listener);
        recyclerView.setPadding(0, 0, 0, this.getContext().getResources().getDimensionPixelSize(R.dimen.db_viewer_grid_row_spacing));
        recyclerView.setHasFixedSize(true);
        recyclerView.setRecycledViewPool(this.recyclerViewPoolItems);
        this.recyclerViews.add(new DbViewerRecyclerViewModel(view, recyclerView, adapter));
        return view;
    }

    private void scrollToX(int tagId, int scrollX) {
        for (DbViewerRecyclerViewModel model : this.recyclerViews) {
            if ((Integer)model.recyclerView.getTag() == tagId) continue;
            model.recyclerView.removeOnScrollListener(this.listener);
            model.recyclerView.scrollBy(scrollX, 0);
            model.recyclerView.addOnScrollListener(this.listener);
        }
    }

    private List<ArrayList<DbViewerDataModel>> getDataForPage(int currentPage, int maxPerPage, ArrayList<ArrayList<DbViewerDataModel>> data) {
        int from = --currentPage * --maxPerPage;
        int to = currentPage * maxPerPage + maxPerPage;
        if (from > data.size()) {
            from = data.size();
        }
        if (to > data.size()) {
            to = data.size();
        }
        return data.subList(from, to);
    }

    private void setBottomPages() {
        this.pageTxt.setText((CharSequence)(this.currentPage + "/" + (this.totalPage == 0 ? 1 : this.totalPage)));
    }

    public boolean canGoBack() {
        if (this.screenType == 2) {
            this.displayTables();
            return false;
        }
        if (this.screenType == 1) {
            this.displayDatabases();
            return false;
        }
        return true;
    }

    @Override
    public void onHeaderClick(DbViewerDataModel model) {
        if (this.data != null && !this.data.isEmpty()) {
            Object dbModel;
            int pos = -1;
            ArrayList<DbViewerDataModel> dbViewerRowModels = this.data.get(0);
            for (int i = 0; i < dbViewerRowModels.size(); ++i) {
                dbModel = dbViewerRowModels.get(i);
                if (!((DbViewerDataModel)dbModel).isHeader() && !((DbViewerDataModel)dbModel).isRow() || !((DbViewerDataModel)dbModel).dbKey.equals(model.dbKey)) continue;
                pos = i;
                break;
            }
            if (pos != -1) {
                int sortType = this.comparator.getSortType();
                if (this.lastHeaderPos == -1 || pos != this.lastHeaderPos || sortType == -1) {
                    sortType = 0;
                } else if (sortType == 0) {
                    sortType = 1;
                } else if (sortType == 1) {
                    sortType = -1;
                    pos = 0;
                }
                this.comparator.setRow(pos);
                this.comparator.setSortType(sortType);
                Collections.sort(this.data, this.comparator);
                if (this.recyclerViews != null && !this.recyclerViews.isEmpty() && ((DbViewerRecyclerViewModel)(dbModel = this.recyclerViews.get(0))).areValidData()) {
                    ((DbViewerRecyclerViewModel)dbModel).adapter.highlightHeader(model, sortType);
                }
                this.lastHeaderPos = pos;
            }
            this.refreshGridList();
        }
    }

    @Override
    public void highlightCell(int row) {
        if (this.recyclerViews != null) {
            for (DbViewerRecyclerViewModel dbModel : this.recyclerViews) {
                if (!dbModel.areValidData()) continue;
                dbModel.adapter.highlightRow(row);
            }
        }
    }

    @Override
    public void showDetailCell(DbViewerDataModel model) {
        this.showDetailCell(model, ((DbViewerRowModel)model).getCleanedText());
    }

    public void showDetailCell(final DbViewerDataModel model, String data) {
        this.yesNoDialog(data, "Close", !this.isEmpty(this.selectedTable) ? "Edit" : null, "Format", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int which) {
                if (which == -2) {
                    DbGridView.this.inputDialog("Edit cell", ((DbViewerRowModel)model).getCleanedText(), "Save", "Cancel", "Clear", new DbViewerInputListener(){

                        @Override
                        public void applyInput(String text) {
                            DbGridView.this.saveData(model, text);
                        }

                        @Override
                        public void neutral() {
                            DbGridView.this.saveData(model, null);
                        }
                    });
                } else if (which == -3) {
                    DbGridView.this.showDetailCell(model, ((DbViewerRowModel)model).getCleanedText(true));
                }
            }
        });
    }

    private void saveData(DbViewerDataModel model, String text) {
        if (this.isEmpty(text)) {
            text = "";
        }
        ContentValues cv = new ContentValues();
        cv.put(model.dbKey, text);
        this.dbHelper.update(this.selectedTable, cv, ((DbViewerRowModel)model).primaryColumnName + "=?", new String[]{String.valueOf(((DbViewerRowModel)model).primaryColumnValue)});
        this.displayData(this.selectedTable, null);
    }
}

