/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.dbviewer.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.dbviewer.listeners.DbViewerGridItemListener;
import com.jantursky.debugger.components.dbviewer.models.DbViewerDataModel;
import com.jantursky.debugger.components.dbviewer.models.DbViewerRowModel;
import java.util.ArrayList;

public class DbViewerGridRowAdapter
extends RecyclerView.Adapter<ItemHolder> {
    private static final int TYPE_HEADER = 1;
    private static final int TYPE_ROW = 2;
    private static final int TYPE_HEADER_EMPTY = 3;
    private static final int TYPE_ROW_POSITION = 4;
    private final int colorHidden;
    private final int colorNormal;
    private final int colorHeader;
    private boolean isHeader;
    private boolean isSelected;
    private int sortType = 0;
    private int selectedHeaderSort = -1;
    private int currentPage;
    private int maxPerPage;
    private int rowPos = -1;
    private ArrayList<DbViewerDataModel> array;
    private DbViewerGridItemListener listener;

    public DbViewerGridRowAdapter(Context context, boolean isHeader) {
        this.isHeader = isHeader;
        this.colorHidden = ContextCompat.getColor((Context)context, (int)R.color.db_viewer_grid_bg);
        this.colorNormal = ContextCompat.getColor((Context)context, (int)R.color.db_viewer_grid_row_txt);
        this.colorHeader = ContextCompat.getColor((Context)context, (int)R.color.db_viewer_grid_row_header_txt);
        this.setHasStableIds(true);
    }

    public long getItemId(int position) {
        return this.getItem((int)position).columnPos;
    }

    public void setOnItemClickListener(DbViewerGridItemListener listener) {
        this.listener = listener;
    }

    public int getItemViewType(int position) {
        int rowType = this.getItem((int)position).rowType;
        if (rowType == 0) {
            return 1;
        }
        if (rowType == 1) {
            return 3;
        }
        if (rowType == 2) {
            return 2;
        }
        if (rowType == 3) {
            return 4;
        }
        return 2;
    }

    public DbViewerDataModel getItem(int pos) {
        return this.array.get(pos);
    }

    public void setData(ArrayList<DbViewerDataModel> arrayList, int columns, boolean isHeader, int currentPage, int maxPerPage, int rowPos) {
        if (this.array == null) {
            this.array = new ArrayList();
        } else {
            this.array.clear();
        }
        this.isHeader = isHeader;
        this.currentPage = currentPage;
        this.maxPerPage = maxPerPage;
        this.rowPos = rowPos;
        if (arrayList != null && !arrayList.isEmpty()) {
            this.array.addAll(arrayList);
        } else {
            for (int i = 0; i < columns; ++i) {
                this.array.add(new DbViewerRowModel(-1, true, 2, null, null));
            }
        }
        this.notifyDataSetChanged();
    }

    public void highlightRow(int row) {
        this.isSelected = row == this.rowPos;
        this.notifyDataSetChanged();
    }

    public void highlightHeader(DbViewerDataModel model, int sortType) {
        if (this.isHeader) {
            for (int i = 0; i < this.array.size(); ++i) {
                DbViewerDataModel dbViewerRowModel = this.array.get(i);
                if (!dbViewerRowModel.isHeader() || !dbViewerRowModel.dbKey.equals(model.dbKey)) continue;
                this.selectedHeaderSort = i;
                this.sortType = sortType;
                break;
            }
            this.notifyDataSetChanged();
        }
    }

    public int getItemCount() {
        return null != this.array ? this.array.size() : 0;
    }

    @NonNull
    public ItemHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = viewType == 1 ? LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_db_viewer_grid_header_row, viewGroup, false) : (viewType == 3 ? LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_db_viewer_grid_header_position_row, viewGroup, false) : (viewType == 2 ? LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_db_viewer_grid_row, viewGroup, false) : LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_db_viewer_grid_position_row, viewGroup, false)));
        return new ItemHolder(view, viewType);
    }

    public void onBindViewHolder(final @NonNull ItemHolder holder, int position) {
        DbViewerDataModel model = this.getItem(position);
        if (model.isHidden) {
            holder.rootLayout.setBackgroundColor(this.colorHidden);
            holder.delimiter.setVisibility(8);
            holder.rootLayout.setOnClickListener(null);
            holder.txtName.setText((CharSequence)"");
        } else {
            if (position < this.getItemCount() - 1) {
                holder.delimiter.setVisibility(0);
            } else {
                holder.delimiter.setVisibility(8);
            }
            if (model.isHeader()) {
                if (position == this.selectedHeaderSort) {
                    if (this.sortType == -1) {
                        holder.txtSort.setVisibility(8);
                    } else {
                        holder.txtSort.setVisibility(0);
                        holder.txtSort.setText((CharSequence)(this.sortType == 0 ? "\u25b2" : "\u25bc"));
                    }
                } else {
                    holder.txtSort.setVisibility(8);
                }
                holder.txtName.setTextColor(this.colorHeader);
                holder.txtType.setText((CharSequence)model.geType());
                holder.txtName.setText((CharSequence)model.getText());
                holder.rootLayout.setBackgroundResource(R.drawable.db_viewer_grid_row_header_item_selector);
                holder.rootLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int pos = holder.getAdapterPosition();
                        if (pos != -1 && DbViewerGridRowAdapter.this.listener != null) {
                            DbViewerGridRowAdapter.this.listener.onHeaderClick(DbViewerGridRowAdapter.this.getItem(pos));
                        }
                    }
                });
            } else if (model.isRow()) {
                holder.txtName.setTextColor(this.colorNormal);
                holder.txtName.setText((CharSequence)model.getText());
                holder.rootLayout.setBackgroundResource(R.drawable.db_viewer_grid_row_item_selector);
                holder.rootLayout.setSelected(this.isSelected);
                holder.rootLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int pos = holder.getAdapterPosition();
                        if (pos != -1 && DbViewerGridRowAdapter.this.listener != null) {
                            DbViewerGridRowAdapter.this.listener.highlightCell(DbViewerGridRowAdapter.this.rowPos);
                        }
                    }
                });
                holder.rootLayout.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        int pos = holder.getAdapterPosition();
                        if (pos != -1 && DbViewerGridRowAdapter.this.listener != null) {
                            DbViewerGridRowAdapter.this.listener.showDetailCell(DbViewerGridRowAdapter.this.getItem(pos));
                        }
                        return true;
                    }
                });
            } else if (model.isRowPosition()) {
                holder.txtName.setText((CharSequence)String.valueOf((this.currentPage - 1) * (this.maxPerPage - 1) + this.rowPos));
            } else if (model.isEmptyHeader()) {
                // empty if block
            }
        }
    }

    public class ItemHolder
    extends RecyclerView.ViewHolder {
        protected FrameLayout rootLayout;
        protected TextView txtName;
        protected TextView txtType;
        protected TextView txtSort;
        protected View delimiter;

        public ItemHolder(View view, int viewType) {
            super(view);
            if (viewType == 1) {
                this.rootLayout = (FrameLayout)view.findViewById(R.id.root_layout);
                this.txtName = (TextView)view.findViewById(R.id.name_textview);
                this.delimiter = view.findViewById(R.id.delimiter);
                this.txtType = (TextView)view.findViewById(R.id.header_textview);
                this.txtSort = (TextView)view.findViewById(R.id.sort_textview);
            } else if (viewType == 3) {
                this.rootLayout = (FrameLayout)view.findViewById(R.id.root_layout);
                this.delimiter = view.findViewById(R.id.delimiter);
            } else if (viewType == 2) {
                this.rootLayout = (FrameLayout)view.findViewById(R.id.root_layout);
                this.txtName = (TextView)view.findViewById(R.id.name_textview);
                this.delimiter = view.findViewById(R.id.delimiter);
                this.txtType = (TextView)view.findViewById(R.id.header_textview);
                this.txtSort = (TextView)view.findViewById(R.id.sort_textview);
            } else if (viewType == 4) {
                this.rootLayout = (FrameLayout)view.findViewById(R.id.root_layout);
                this.txtName = (TextView)view.findViewById(R.id.name_textview);
                this.delimiter = view.findViewById(R.id.delimiter);
            }
        }
    }
}

