/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.restclient;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.jantursky.debugger.R;
import com.jantursky.debugger.components.restclient.adapters.RestClientListAdapter;
import com.jantursky.debugger.components.restclient.interfaces.RestClientListItemListener;
import com.jantursky.debugger.components.restclient.interfaces.RestClientResultListener;
import com.jantursky.debugger.components.restclient.models.ApiCallModel;
import com.jantursky.debugger.components.restclient.models.ApiGeneralModel;
import com.jantursky.debugger.components.restclient.tasks.ApiCallTask;
import com.jantursky.debugger.interfaces.ComponentListener;
import com.jantursky.debugger.utils.JsonUtils;
import com.jantursky.debugger.utils.RecyclerViewUtils;
import com.jantursky.debugger.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class RestClientView
extends FrameLayout
implements View.OnClickListener,
RestClientListItemListener,
RestClientResultListener {
    private static final String TAG = RestClientView.class.getSimpleName();
    private TextView txtRunAll;
    private TextView txtClose;
    private TextView txtGlobalHeaders;
    private RestClientListAdapter restClientListAdapter;
    private RecyclerView recyclerViewList;
    private ComponentListener componentListener;
    private ApiGeneralModel apiCallGeneralModel;
    private SparseArray<ApiCallTask> tasks = new SparseArray();

    public RestClientView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public RestClientView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RestClientView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public RestClientView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_rest_client, (ViewGroup)this, true);
        this.recyclerViewList = (RecyclerView)view.findViewById(R.id.list_recycler_view);
        this.txtClose = (TextView)view.findViewById(R.id.close_textview);
        this.txtRunAll = (TextView)view.findViewById(R.id.run_all_textview);
        this.txtGlobalHeaders = (TextView)view.findViewById(R.id.global_headers_textview);
        this.setList();
        this.setListeners();
    }

    public void setComponentListener(ComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    private void setList() {
        this.restClientListAdapter = new RestClientListAdapter(this.getContext());
        this.recyclerViewList.addItemDecoration((RecyclerView.ItemDecoration)RecyclerViewUtils.getVerticalItemDecoration(this.getContext()));
        this.recyclerViewList.setAdapter((RecyclerView.Adapter)this.restClientListAdapter);
        ((SimpleItemAnimator)this.recyclerViewList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.restClientListAdapter.setOnItemClickListener(this);
    }

    private void setListeners() {
        this.txtRunAll.setOnClickListener((View.OnClickListener)this);
        this.txtGlobalHeaders.setOnClickListener((View.OnClickListener)this);
        this.txtClose.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.close_textview) {
            this.stopAllCalls();
            if (this.componentListener != null) {
                this.componentListener.closeComponent();
            }
        } else if (viewId == R.id.run_all_textview) {
            if (this.hasRunningTask()) {
                this.stopAllCalls();
            } else if (RestClientView.isNetworkAvailable(this.getContext())) {
                this.runAllCalls();
            } else {
                Toast.makeText((Context)this.getContext(), (int)R.string.toast_no_network, (int)0).show();
            }
            this.updateStatus();
        } else if (viewId == R.id.global_headers_textview) {
            this.editGlobalHeaders();
        }
    }

    private void editGlobalHeaders() {
        LayoutInflater li = LayoutInflater.from((Context)this.getContext());
        View promptsView = li.inflate(R.layout.dialog_rest_headers, null);
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.getContext());
        alertDialogBuilder.setView(promptsView);
        final LinearLayout ltContent = (LinearLayout)promptsView.findViewById(R.id.content_layout);
        TextView txtAdd = (TextView)promptsView.findViewById(R.id.add_textview);
        TextView txtCancel = (TextView)promptsView.findViewById(R.id.cancel_textview);
        TextView txtSave = (TextView)promptsView.findViewById(R.id.save_textview);
        if (this.apiCallGeneralModel.hasHeaders()) {
            for (Map.Entry<String, String> entry : this.apiCallGeneralModel.headers.entrySet()) {
                this.addHeaderRow(ltContent, entry.getKey(), entry.getValue());
            }
        }
        alertDialogBuilder.setCancelable(false);
        final AlertDialog alertDialog = alertDialogBuilder.create();
        alertDialog.show();
        txtCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });
        txtSave.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                for (int i = 0; i < ltContent.getChildCount(); ++i) {
                    EditText editTextKey = (EditText)ltContent.getChildAt(i).findViewById(R.id.input_key_edittext);
                    EditText editTextValue = (EditText)ltContent.getChildAt(i).findViewById(R.id.input_value_edittext);
                    String key = editTextKey.getText().toString();
                    String value = editTextValue.getText().toString();
                    headers.put(key, value);
                }
                RestClientView.this.apiCallGeneralModel.setHeaders(headers);
                RestClientView.this.restClientListAdapter.updateApiGeneralMode(RestClientView.this.apiCallGeneralModel);
                alertDialog.dismiss();
            }
        });
        txtAdd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RestClientView.this.addHeaderRow(ltContent, "", "");
            }
        });
    }

    private void updateStatus() {
        if (this.hasRunningTask()) {
            this.txtRunAll.setText(R.string.action_stop_all_api_call);
        } else {
            this.txtRunAll.setText(R.string.action_run_all_api_call);
        }
    }

    private void runAllCalls() {
        ArrayList<ApiCallModel> data = this.restClientListAdapter.getData();
        for (ApiCallModel model : data) {
            this.runCall(model);
        }
    }

    private void stopAllCalls() {
        ArrayList<ApiCallModel> data = this.restClientListAdapter.getData();
        for (ApiCallModel model : data) {
            this.stopCall(model);
        }
    }

    @Override
    public void onRowClick(ApiCallModel model) {
    }

    @Override
    public void runCall(ApiCallModel model) {
        if (RestClientView.isNetworkAvailable(this.getContext())) {
            if (this.isRunning(model)) {
                this.cancel(model);
            }
            this.restClientListAdapter.runApiCall(model);
            ApiCallTask task = new ApiCallTask(model, this);
            this.tasks.put(model.getId(), (Object)task);
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            Toast.makeText((Context)this.getContext(), (int)R.string.toast_no_network, (int)0).show();
        }
        this.updateStatus();
    }

    private void cancel(ApiCallModel model) {
        if (this.tasks.get(model.getId()) != null) {
            RestClientView.closeTask((AsyncTask)this.tasks.get(model.getId()));
            this.tasks.remove(model.getId());
            this.restClientListAdapter.cancelApiCall(model);
        }
    }

    private boolean isRunning(ApiCallModel model) {
        return this.tasks.get(model.getId()) != null && RestClientView.isRunningTask((AsyncTask)this.tasks.get(model.getId()));
    }

    @Override
    public void stopCall(ApiCallModel model) {
        this.cancel(model);
    }

    @Override
    public void editHeaders(ApiCallModel model) {
    }

    private void addHeaderRow(LinearLayout layout2, String key, String value) {
        LayoutInflater li = LayoutInflater.from((Context)this.getContext());
        View view = li.inflate(R.layout.item_rest_header_row, null);
        EditText inputKeyEdittext = (EditText)view.findViewById(R.id.input_key_edittext);
        EditText inputValueEdittext = (EditText)view.findViewById(R.id.input_value_edittext);
        TextView txtDelete = (TextView)view.findViewById(R.id.delete_textview);
        if (!StringUtils.isEmpty(key)) {
            inputKeyEdittext.setText((CharSequence)key);
        }
        if (!StringUtils.isEmpty(value)) {
            inputValueEdittext.setText((CharSequence)value);
        }
        txtDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((LinearLayout)view.getParent().getParent()).removeView((View)view.getParent());
            }
        });
        layout2.addView(view);
    }

    @Override
    public void displayOutputDetail(ApiCallModel model) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle(model.hasResponseData() ? R.string.rest_output : R.string.rest_error_output);
        TextView input = new TextView(this.getContext());
        input.setText((CharSequence)JsonUtils.getIndentedText(model.getResponseOrErrorData()));
        input.setPadding(32, 32, 32, 32);
        input.setSingleLine(false);
        builder.setView((View)input);
        builder.setNegativeButton(R.string.action_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        builder.show();
    }

    public void setApiCalls(ApiGeneralModel apiCallGeneralModel, ArrayList<ApiCallModel> apiCalls) {
        this.apiCallGeneralModel = apiCallGeneralModel;
        this.restClientListAdapter.setData(apiCallGeneralModel, apiCalls);
    }

    public boolean hasRunningTask() {
        return this.tasks.size() > 0;
    }

    public static void closeTask(AsyncTask ... tasks) {
        for (AsyncTask task : tasks) {
            if (!RestClientView.isRunningTask(task)) continue;
            task.cancel(true);
        }
    }

    public static boolean isRunningTask(AsyncTask task) {
        return task != null && (task.getStatus() == AsyncTask.Status.PENDING || task.getStatus() == AsyncTask.Status.RUNNING);
    }

    @Override
    public void onApiCallResult(ApiCallModel model) {
        this.restClientListAdapter.updateApiCallResult(model);
        this.removeTask(model);
        this.updateStatus();
    }

    @Override
    public void onApiCallCancel(ApiCallModel model) {
        this.restClientListAdapter.updateApiCallResult(model);
        this.removeTask(model);
        this.updateStatus();
    }

    private void removeTask(ApiCallModel model) {
        if (this.tasks.get(model.getId()) != null) {
            this.tasks.remove(model.getId());
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetworkInfo = null;
            if (connectivityManager != null) {
                activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            }
            return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
        }
        catch (Exception e) {
            return false;
        }
    }
}

