/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.components.dbviewer.helpers;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class ItemDecorationGrid
extends RecyclerView.ItemDecoration {
    private final int mSizeGridSpacingPx;
    private final int mGridSize;
    private boolean mNeedLeftSpacing = false;

    public ItemDecorationGrid(int gridSpacingPx, int gridSize) {
        this.mSizeGridSpacingPx = gridSpacingPx;
        this.mGridSize = gridSize;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int frameWidth = (int)(((float)parent.getWidth() - (float)this.mSizeGridSpacingPx * (float)(this.mGridSize - 1)) / (float)this.mGridSize);
        int padding = parent.getWidth() / this.mGridSize - frameWidth;
        int itemPosition = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewAdapterPosition();
        outRect.top = itemPosition < this.mGridSize ? 0 : this.mSizeGridSpacingPx;
        if (itemPosition % this.mGridSize == 0) {
            outRect.left = 0;
            outRect.right = padding;
            this.mNeedLeftSpacing = true;
        } else if ((itemPosition + 1) % this.mGridSize == 0) {
            this.mNeedLeftSpacing = false;
            outRect.right = 0;
            outRect.left = padding;
        } else if (this.mNeedLeftSpacing) {
            this.mNeedLeftSpacing = false;
            outRect.left = this.mSizeGridSpacingPx - padding;
            outRect.right = (itemPosition + 2) % this.mGridSize == 0 ? this.mSizeGridSpacingPx - padding : this.mSizeGridSpacingPx / 2;
        } else if ((itemPosition + 2) % this.mGridSize == 0) {
            this.mNeedLeftSpacing = false;
            outRect.left = this.mSizeGridSpacingPx / 2;
            outRect.right = this.mSizeGridSpacingPx - padding;
        } else {
            this.mNeedLeftSpacing = false;
            outRect.left = this.mSizeGridSpacingPx / 2;
            outRect.right = this.mSizeGridSpacingPx / 2;
        }
        outRect.bottom = 0;
    }
}

