/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static final String TAG = JsonUtils.class.getSimpleName();

    public static boolean isJSONObjectValid(String test) {
        try {
            new JSONObject(test);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static boolean isJSONArrayValid(String test) {
        try {
            new JSONArray(test);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static String getIndentedText(String text) {
        if (JsonUtils.isJSONObjectValid(text)) {
            try {
                return new JSONObject(text).toString(3);
            }
            catch (JSONException jSONException) {
            }
        } else if (JsonUtils.isJSONArrayValid(text)) {
            try {
                return new JSONArray(text).toString(3);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return text;
    }
}

