/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.dbviewer.models;

import com.jantursky.debugger.utils.JsonUtils;

public class DbViewerDataModel {
    public final int columnPos;
    public String dbKey;
    public int type;
    public String typeText;
    public boolean isHidden;
    public final int rowType;
    public int valueInt;
    public float valueFloat;
    public String valueString;

    public DbViewerDataModel(int columnPos, int rowType) {
        this.columnPos = columnPos;
        this.rowType = rowType;
    }

    public DbViewerDataModel(int columnPos, boolean isHidden, int rowType) {
        this.columnPos = columnPos;
        this.isHidden = isHidden;
        this.rowType = rowType;
    }

    public DbViewerDataModel(int columnPos, String dbKey, String name, String type, int rowType) {
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.valueString = name;
        this.typeText = type;
        this.rowType = rowType;
    }

    public DbViewerDataModel(int columnPos, String dbKey, int type, int rowType, int valueInt) {
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.type = type;
        this.rowType = rowType;
        this.valueInt = valueInt;
    }

    public DbViewerDataModel(int columnPos, String dbKey, int type, int rowType, float valueFloat) {
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.type = type;
        this.rowType = rowType;
        this.valueFloat = valueFloat;
    }

    public DbViewerDataModel(int columnPos, String dbKey, int type, int rowType, String valueString) {
        this.columnPos = columnPos;
        this.dbKey = dbKey;
        this.type = type;
        this.rowType = rowType;
        this.valueString = valueString;
    }

    public String toString() {
        return "DbViewerDataModel{type=" + this.type + ", typeText='" + this.typeText + '\'' + ", rowType=" + this.rowType + ", valueInt=" + this.valueInt + ", valueFloat=" + this.valueFloat + ", valueString='" + this.valueString + '\'' + '}';
    }

    public String getText() {
        if (this.rowType == 0) {
            return this.valueString;
        }
        if (this.rowType == 2) {
            if (this.type == 3) {
                return this.valueString;
            }
            if (this.type == 1) {
                return String.valueOf(this.valueInt);
            }
            if (this.type == 2) {
                return String.valueOf(this.valueFloat);
            }
            if (this.type == 4) {
                return this.valueString;
            }
            return "";
        }
        return "";
    }

    public String getCleanedText() {
        return JsonUtils.getIndentedText(this.getText());
    }

    public String geType() {
        return this.typeText;
    }

    public boolean isEmptyHeader() {
        return this.rowType == 1;
    }

    public boolean isHeader() {
        return this.rowType == 0;
    }

    public boolean isRow() {
        return this.rowType == 2;
    }

    public boolean isRowPosition() {
        return this.rowType == 3;
    }
}

