/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.dbviewer.models;

import com.jantursky.debugger.utils.JsonUtils;

public class DbViewerDataModel {
    public String dbKey;
    public int type;
    public String typeText;
    public boolean isHidden;
    public boolean isHeader;
    public int valueInt;
    public float valueFloat;
    public String valueString;

    public DbViewerDataModel(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public DbViewerDataModel(String dbKey, String name, String type, boolean isHeader) {
        this.dbKey = dbKey;
        this.valueString = name;
        this.typeText = type;
        this.isHeader = isHeader;
    }

    public DbViewerDataModel(String dbKey, int type, int valueInt) {
        this.dbKey = dbKey;
        this.type = type;
        this.valueInt = valueInt;
    }

    public DbViewerDataModel(String dbKey, int type, float valueFloat) {
        this.dbKey = dbKey;
        this.type = type;
        this.valueFloat = valueFloat;
    }

    public DbViewerDataModel(String dbKey, int type, String valueString) {
        this.dbKey = dbKey;
        this.type = type;
        this.valueString = valueString;
    }

    public String toString() {
        return "DbViewerDataModel{type=" + this.type + ", typeText='" + this.typeText + '\'' + ", isHeader=" + this.isHeader + ", valueInt=" + this.valueInt + ", valueFloat=" + this.valueFloat + ", valueString='" + this.valueString + '\'' + '}';
    }

    public String getText() {
        if (this.isHeader) {
            return this.valueString;
        }
        if (this.type == 3) {
            return this.valueString;
        }
        if (this.type == 1) {
            return String.valueOf(this.valueInt);
        }
        if (this.type == 2) {
            return String.valueOf(this.valueFloat);
        }
        if (this.type == 4) {
            return this.valueString;
        }
        return "";
    }

    public String getCleanedText() {
        return JsonUtils.getIndentedText(this.getText());
    }

    public String geType() {
        return this.typeText;
    }
}

